# $Id: TMMCommandLineIF.tcl,v 1.2 2002/03/04 20:01:49 issever Exp $

# ==========================================================
# TMapManager::TCommandLineIF
#     This class is a helper class for the TMapManager, thus
#     it was placed into the TMapManager namespace.
#
# --- This class provides the command line access to the 
#     mapmanager and thus to the maps. This is the way how
#     to interact with maps via the command line.
# ==========================================================

namespace eval TMapManager {
    
    class TCommandLineIF {

	private {
	    # ----------------------------------------------
	    variable _zif
	    variable _bgIM
	    variable _mud
	    variable _ses
	    # ----------------------------------------------
	}
	protected {
	    # ----------------------------------------------
	    method _init {aZif aBgIM}
	    # ----------------------------------------------
	    method _setMud {aMud}
	    # ----------------------------------------------
	    method _setSes {aSes}
	    # ----------------------------------------------
	}
	# --------------------------------------------------
	# The following methods simulate using the ZIF.
	# Setters
	# --------------------------------------------------
	method acceptRoom {}
	method resetRoom {} 
	method zifRemoveRoom {}
	method zifSetBg {aType aCat aName} 
	method zifSetStuff {aPos aType aCat aName}
	method zifRemStuff {aPos}
	method zifSetText {aText}
	method zifRemText {}
	method zifRemExit {aPos}
	method zifSetExit {aPos aCommand 
			   aMapName aMapLevel 
			   aConX aConY aDrawX aDrawY
			   aDoor aDoorComOpen aDoorComClose
			   aThickness aColor } 
	# --------------------------------------------------
	# Getters
	# --------------------------------------------------
	method getExitWithCommand {aName aLevel aX aY aCom} 
	method setZoomPos {aMapName aMapLevel aX aY} 
	method setPlayerPos {aMapName aMapLevel aX aY} 
	method changeMap {aMapName aMapLevel} 
	method createMap {aMapName aMapLevel} 
	# --------------------------------------------------
	method CLPowerwalk {aMapName aMapLevel aX aY}
	# Starts powerwalking to the transmitted 
	# destination.
	# --------------------------------------------------
    }

    # ======================================================
    # === class code
    # ======================================================

    # ------------------------------------------------------
    # --- protected; setters
    # ------------------------------------------------------
    body TCommandLineIF::_init {aZif aBgIM} {
	set _zif  $aZif
	set _bgIM $aBgIM
    }
    body TCommandLineIF::_setMud {aMud} {
	set _mud  $aMud
    }
    body TCommandLineIF::_setSes {aSes} {
	set _ses  $aSes
    }

    # ------------------------------------------------------
    # --- setters
    # ------------------------------------------------------
    body TCommandLineIF::acceptRoom {} {
	$_zif accept
    } 
    body TCommandLineIF::resetRoom {} {
	$_zif resetit
    } 
    body TCommandLineIF::zifRemoveRoom {} { 
	$_zif clearUif
    }
    body TCommandLineIF::zifSetBg {aType aCat aName} {	
	$_zif zifSetBg [$_bgIM getObject $aType $aCat $aName]
    }
    body TCommandLineIF::zifSetStuff {aPos aType aCat aName} {	
	$_zif zifSetStuff $aPos [$_bgIM getObject $aType $aCat $aName]
    }
    body TCommandLineIF::zifRemStuff {aPos} {
	$_zif zifRemStuff $aPos 
    }
    body TCommandLineIF::zifSetText {aText} {	
	$_zif zifSetText $aText
    }
    body TCommandLineIF::zifRemText {} {
	$_zif zifRemText 
    }
    body TCommandLineIF::zifRemExit {aPos} {
	$_zif zifRemExit $aPos
    }
    body TCommandLineIF::zifSetExit {
	aPos aCommand 
	aMapName aMapLevel 
	aConX aConY aDrawX aDrawY
	aDoor aDoorComOpen aDoorComClose
	aThickness aColor 
    } {
	set cc [TCoordinate ::\#auto $aConX $aConY]
	set cd [TCoordinate ::\#auto $aDrawX $aDrawY]

	set ex [TExit ::\#auto \
		    $aPos $aMapName $aMapLevel \
		    $cc $cd \
		    $aCommand \
		    $aDoor $aDoorComOpen $aDoorComClose \
		    $aThickness $aColor ]

	$_zif zifSetExit $ex
	::delete object $ex $cc $cd

    }
    # ------------------------------------------------------
    # --- getters
    # ------------------------------------------------------
    body TCommandLineIF::getExitWithCommand {
	aName aLevel aX aY aCom
    } {
	# used by TEntryX
	if {[TMapManager::existsRoom $aName $aLevel $aX $aY]} {
	    set room [TMapManager::getRoom $aName $aLevel $aX $aY]
	    return [$room getPosOfExitWithCommand $aCom]
	}
	return ""
    }
    body TCommandLineIF::setZoomPos {aMapName aMapLevel aX aY} {
	# used by TEntryX
	set map [$_mud getMap $aMapName $aMapLevel]
	TMapManager::newZoomPos $map $aX $aY
    }
    body TCommandLineIF::setPlayerPos {aMapName aMapLevel aX aY} {
	# used by TEntryX
	set map [$_mud getMap $aMapName $aMapLevel]
	TMapManager::newPlayerPos $map $aX $aY
    }
    body TCommandLineIF::changeMap {aMapName aMapLevel} {
	# used by TEntryX
	if {[$_mud existsMap $aMapName $aMapLevel]} {
	    TMapManager::newActMap [$_mud getMap $aMapName $aMapLevel]
	}
    }
    body TCommandLineIF::createMap {aMapName aMapLevel} {
	# used by TEntryX
	if {![regexp -- {^[-+]?[0-9]+$} $aMapLevel]} {
	    $_ses writeMessage "Level argument is not integer!"
	    return
	}	
	if {[$_mud existsMap $aMapName $aMapLevel]} {
	    $_ses writeMessage "Map already exists!"
	    return
	}	
	TMapManager::reallyCreateNewMap "\{$aMapName\}" "\{$aMapLevel\}"
    }
    # ------------------------------------------------------
    # --- movers
    # ------------------------------------------------------
    body TCommandLineIF::CLPowerwalk {aMapName aMapLevel aX aY} {
	# used by TEnryX
	if {[TMapManager::roomHasChanged]} {
	    if {[devMode]} {
		acceptRoom
	    } else {
		$_ses writeMessage "Current room in zoom interface hasnt been saved!"
		return
	    }
	}
	
	if {[$_mud existsMap $aMapName $aMapLevel]} {	    
	    TMapManager::powerWalkTo [$_mud getMap $aMapName $aMapLevel] $aX $aY
	} else {
	    $_ses writeMessage "There is no such map ('$aMapName', '$aMapLevel')!"
	}
	
    }


    # --- namespace end    
}


# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TMMCommandLineIF.tcl,v $
# Revision 1.2  2002/03/04 20:01:49  issever
# bugfix: map access from the commandline
#
# Revision 1.1  2002/02/11 20:24:32  issever
# cut/copy/paste for maps, drag&drop, code cleanup of mapmanager
#
