# $Id: TMMDevMode.tcl,v 1.1 2002/02/11 20:24:32 issever Exp $

# ==========================================================
# TMapManager::TDevMode
# ==========================================================

namespace eval TMapManager {
    # --- This namespace will contain helperclasses for
    #     the TMapManager.


    # ======================================================
    # --- TDevMode
    # --- If devmode is turned on, rooms are automatically
    #     accepted, when the room is left.
    # ======================================================
    class TDevMode {
	# --- The variable devModeVariable stores the status of
	#     the development mode. 
	private {
	    variable _devModeVariable 1
	}

	# --- Returns the pointer to the variable.
	method getDevModeVariable {} { return [scope _devModeVariable]}
	# --- Getters and setters.
	method devMode {} { return $_devModeVariable}
	method setDevMode {aMode} { return [set _devModeVariable $aMode]}	
    }

}





# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TMMDevMode.tcl,v $
# Revision 1.1  2002/02/11 20:24:32  issever
# cut/copy/paste for maps, drag&drop, code cleanup of mapmanager
#

