# $Id: TMud.tcl,v 1.4 2001/12/07 23:48:38 issever Exp $

class TMudManager {
    private common CMudList  ;# is an array of objects
    private common CFilM     ;# the file system manager

    constructor {aFileSystemManager args} {
	set CFilM $aFileSystemManager

	foreach mf [$CFilM getAllMudDataFiles] {
	    set mud [TMud ::\#auto $CFilM $mf]
	    set CMudList([$mud name]) $mud
	}
    }
    method add {aName aHost aPort} {
	if {[exists $aName]} {
	    ::delete object $CMudList($aName)
	    unset CMudList($aName)	
	}
	set id [getNewId]
	set CMudList($aName) [TMud ::\#auto $CFilM $aName $aHost $aPort $id]
    }
    method rem {aName} {
	if {[exists $aName]} {
	    $CMudList($aName) wipeout
	    ::delete object $CMudList($aName)
	    unset CMudList($aName)	
	}
    }
    method getNewId {} {
	set id 0
	set idlist [getMudIds]
	while {[lsearch -exact $idlist $id]!= -1} {
	    incr id
	}
	return $id
    }
    method getMudIds {} { 
	set idlist [list]
	foreach name [getMudNames] {
	    lappend idlist [[getMud $name] id]
	}
	return $idlist
    }
    method getMudNames {} { 
	return [lsort [array names CMudList]] 
    }
    method getMud {aName} { return $CMudList($aName) } 
    method exists {aName} { return [info exists CMudList($aName)] } 
}


#################################################################
class TMud {
    variable CFilM
    variable CName    ;# must be unique
    variable CHost
    variable CPort
    # CId: must be unique too: this is needed to request files and directories for the mud data to be stored
    #  => may never change again! 
    variable CId      
    variable CMapM

    variable CMapArray  ;# this is an array of objects

    constructor {args} {} {
	set CMapM "" ;# must be set later, when a the mud is assigned to a mapmanager
	switch [llength $args] {
	    2 {
		# this is called, if a mud is loaded at start
		set CFilM [lindex $args 0]
		readFile  [lindex $args 1]
		foreach mf [$CFilM getAllMapFiles $CId] {
		    set nli [TMap::getMapNLIFromFile $mf]
		    addMapMain [lindex $nli 0] [lindex $nli 1] [lindex $nli 2] 1
		}
	    }
	    5 {
		# this is called, if a mud is generated new
		set CFilM [lindex $args 0]
		set CName [lindex $args 1]
		set CHost [lindex $args 2]
		set CPort [lindex $args 3]
		set CId   [lindex $args 4]
		createFileSystem
	    }
	    default {
		error "Wrong number of arguments to constructor!"
	    }
	}
    }
    method addMapM {aMapM} { set CMapM $aMapM}
    method remMapM {aMapM} { 
	foreach map [getAllMaps] {
	    $map remMapM $CMapM
	}
	set CMapM ""	
    }
    method getMapM {}    { return $CMapM } 
    ############################################################
    method show {} { puts "$CId -- $CName || $CHost $CPort" }
    method name {} { return $CName }
    method host {} { return $CHost }
    method port {} { return $CPort }
    method id   {} { return $CId }
    ############################################################
    method getAllMapFiles {} {
	return [$CFilM getAllMapFiles $CId]
    }
    method getMapFile {aId} {
	return [$CFilM getMapFile $CId $aId]
    }
    method removeFileSystem {} { 
	file delete -force -- [$CFilM getMudDir    $CId]
    }
    method createFileSystem {} {
	file mkdir    [$CFilM getMudDir    $CId]
	file mkdir    [$CFilM getMudMapDir $CId]

	set    fid [open [$CFilM getMudDataFile $CId] "w+"]
	puts  $fid 1 ;# file version 
	puts  $fid [id]
	puts  $fid [name]
	puts  $fid [host]
	puts  $fid [port]
	close $fid
    }
    method readFile {aFile} {
	set    fid [open $aFile "r"]
	gets  $fid version
	gets  $fid CId
	gets  $fid CName
	gets  $fid CHost
	gets  $fid CPort
	close $fid
    }
    method wipeout {} {
	removeFileSystem
    }

    #############################################################
    method importMap {aFileName aName aLevel}  {
	# add a _new_ map to the MUD
	set aLevel [expr $aLevel]
	if {[existsMap $aName $aLevel]} {
	    return 0
	} 
	set CMapArray($aLevel|$aName) \
	    [TMap ::\#auto import $aFileName $aName $aLevel [getNewMapId] $this [getMapM]]
	return 1
    }
    method addMap {aName aLevel}  {
	# add a _new_ map to the MUD
	set aLevel [expr $aLevel]
	if {[existsMap $aName $aLevel]} {
	    return 0
	} 
	addMapMain $aName $aLevel [getNewMapId] 0
	return 1
    }
    method addMapMain {aName aLevel aId aMustLoad}  {
	set CMapArray($aLevel|$aName) [TMap ::\#auto $aName $aLevel $aId $this $aMustLoad]
    }
    method deleteMap {aMap} {
	set n [$aMap name] 
	set l [$aMap level]
	set i [$aMap id]
	remMap $n $l
	file delete -force -- [getMapFile $i]
	foreach mm $CMapM {
	    $mm updateMapsList
	}
    }
    method remMap {aName aLevel} {
	# rem the Map
	set aLevel [expr $aLevel]
	if {[existsMap $aName $aLevel]} {
	    ::delete object $CMapArray($aLevel|$aName)
	    unset CMapArray($aLevel|$aName)
	}
    }
    method existsMap {aName aLevel} {
	# Q: if the Map exists
	set aLevel [expr $aLevel]
	return [info exists CMapArray($aLevel|$aName)]
    }
    method getAllMaps {} {
	set ml [list]
	foreach mm [array names CMapArray] {
	    lappend ml $CMapArray($mm)
	}
	return $ml
    }
    method getAllMapNamesWithIndicator {} {
	set namellist   [list]
	foreach mm [array names CMapArray] {
	    lappend namellist [$CMapArray($mm) namel]
	}
	set ll [list]
	foreach namel [lsort $namellist] {
	    if { [[getMapFromNamel $namel] hasChanged] } {
		lappend  ll "* $namel"
	    } else {
		lappend  ll ". $namel"
	    }
	}
	return $ll
    }
    method getMapNames {} {
	# R: return the {name level} list of all maps
	set nl   [array names CMapArray]
	set li   [list]    
	foreach mn $nl {
	    regexp -- {(-[0-9]+|\+[0-9]+|[0-9]+)\|(.+)} $mn dummy a b
	    lappend li [list $b $a]
	}
	return $li
    }
    method getChangedMapNames {} {
	# R: return the {name level} list of all maps
	set nl   [array names CMapArray]
	set li   [list]    
	foreach mn $nl {
	    if {[$CMapArray($mn) hasChanged]} {
		regexp -- {(-[0-9]+|\+[0-9]+|[0-9]+)\|(.+)} $mn dummy a b
		lappend li [list $b $a]
	    }
	}
	return $li
    }
    method getMapFromNamel {aNamel} {
	return [getMap [TMap::namelname $aNamel] [TMap::namellevel $aNamel]]
    }
    method getMap {aName aLevel} {
	set aLevel [expr $aLevel]
	# RO: return the corresponding map
	return $CMapArray($aLevel|$aName)
    }
    
    #-----------
    method getAllMapIds {} { 
	set idlist [list]
	foreach mn [getMapNames] {
	    set name  [lindex $mn 0]
	    set level [lindex $mn 1]
	    lappend idlist [[getMap $name $level] id]
	}
	return $idlist
    }
    method getNewMapId {} {
	set id 0
	set idlist [getAllMapIds]
	while {[lsearch -exact $idlist $id]!= -1} {
	    incr id
	}
	return $id
    }

}


#################################################################











# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TMud.tcl,v $
# Revision 1.4  2001/12/07 23:48:38  issever
# Session and Mud Manager totally redone.
# They are now put into one window.
#
# Revision 1.3  2001/11/25 20:30:33  issever
# Removed the -foreground bug.
# This was a quite widespread bug and I hope I caught
# every appereance. If I've missed one, please notify
# us again.
#
# Revision 1.2  2001/08/19 12:25:42  issever
# Added the cvs keywords Id at start of the file
# and Log at the end of the file
#
#
