# $Id: TRoom.tcl,v 1.6 2002/04/21 18:03:16 issever Exp $

### class definition ----------------------------------------

class TRoom {
    inherit \
	TCoordinate \
	TStuffList \
	TExitList
    
    protected variable CBg      ;#the background of this room: TIMAGE Object
    protected variable CText    ;#OBJECT: a text that should be drawn onto the map


    # 0 arguments: creates an empty room
    # 1 arguments: aRoom
    #              creates a copy of aRoom
    # 6 arguments: aCoord aBG aText aStufflist aExitlist
    #              this seems to be bogus, as the number of
    #              arguments does not match in the switch.
    #              It should be 5 arguments?
    constructor {args} {
	switch [llength $args] {
	    0 {
		set CText                [TText ::\#auto]
	    }
	    1 {
		set CText                [TText ::\#auto]
		TRoom::= $args
	    }
	    6 {		
		TCoordinate::constructor [lindex $args 0]
		set CBg                  [lindex $args 1]
		set CText                [TText ::\#auto [lindex $args 2]]
		TStuffList::constructor  [lindex $args 3]
		TExitList::constructor   [lindex $args 4]
	    }
	    default {
		error "Wrong numer of arguments to constructor!"
	    }	    
	}	
    }
    destructor {
	::delete object $CText
    }





    method save {fid} {
	set infolist [list]
	lappend infolist [TCoordinate::streamout]
	lappend infolist [$CBg streamout]	
	lappend infolist [TExitList::streamout]	
	lappend infolist [TStuffList::streamout]	
	lappend infolist [$CText streamout]	
	puts $fid $infolist
    }
    method load {line imm} {
	TCoordinate::streamin  [lindex $line 0]
	set CBg [$imm streamin [lindex $line 1]]
	TExitList::streamin    [lindex $line 2]
	TStuffList::streamin   [lindex $line 3] $imm
	$CText streamin        [lindex $line 4]
    }
    method load_V1ConvertToV2 {line imm} {
	TCoordinate::streamin           [lindex $line 0]
	set CBg [$imm streamin_BGV1ToV2 [lindex $line 1]]
	TExitList::streamin             [lindex $line 2]
	TStuffList::streamin            [lindex $line 3] $imm
	$CText streamin                 [lindex $line 4]
    }
    method = {source} {
	set CBg      [$source bg]
	
	::delete object $CText
	set CText    [TText ::\#auto [$source text]]
	
	TCoordinate::= $source
	TStuffList::= $source
	TExitList::= $source

    }
    method drawStuff {aCanvas xp yp tt aID} {
	set stuff ""
	set ttt   "$tt s$tt"
	foreach pos [TStuffList::getPoss] {
	    set xxp [expr { $xp + [TStuffList::getXOff $pos] }]
	    set yyp [expr { $yp + [TStuffList::getYOff $pos] }]
	    set sIm [[TStuffList::getStuff $pos] getImage]
	    set stuff [$aCanvas create image $xxp $yyp -image $sIm -tag $ttt]
	    $aCanvas raise $stuff $aID

	}
	if {[string compare "" $stuff]} {
	    return "s$tt"
	} else {
	    return $aID
	}
    }
    method drawExitIcons {aCanvas xp yp tt aID} {
	set ex ""
	set ttt "$tt ei$tt"
	foreach pos [TExitList::getPoss] {
	    if {[regexp -- {uo|ux|do|dx} $pos]} {
		set xxp [expr {$xp + $TExitManager::CDirConP($pos,x)}]
		set yyp [expr {$yp + $TExitManager::CDirConP($pos,y)}]
		set ex [$aCanvas create image $xxp $yyp -image $TExitManager::CImage($pos) -tag $ttt]
		$aCanvas raise $ex $aID
	    }
	}
	if {[string compare "" $ex]} {
	    return "ei$tt"
	} else {
	    return $aID
	}
    }
    method getExitPosTo {to} {
	foreach pos [TExitList::getPoss] {
	    if { [[[TExitList::getExit $pos] getDrawTo] isequal $to] } {
		return $pos 
	    }
	}
	return cc
    }
    method getExitPosTo2 {to} {
	foreach pos [TExitList::getPoss] {
	    if { [[[TExitList::getExit $pos] getConnectTo] isequal $to] } {
		return $pos 
	    }
	}
	return cc
    }
    method drawExitConnections {aCanvas xp yp tt aID aMap} {
	#draws lines between rooms
	foreach dir {nw nc ne cw ce sw sc se} {
	    set atag "ec[getXY],$dir"
	    if {[TExitList::exists $dir]} {

		set axp [expr {$xp + $TExitManager::CDirConP($dir,x)}]
		set ayp [expr {$yp + $TExitManager::CDirConP($dir,y)}]
		$aCanvas delete $atag

		set thisExit [TExitList::getExit $dir]
		set cont [$thisExit getDrawTo] ;# this gives back a coordinate object
		if {[$cont isNull]} { continue } ;#dont draw the exit
		set thisThickness [$thisExit getConThickness]
		set thisColor     [$thisExit getConColor]

		set txp  [TMap::m2p [$cont getX] 1]
		set typ  [TMap::m2p [$cont getY] -1]
		set conp [$aMap getConPos $this $cont]
		set ttag "ec[$cont getXY],$conp"
		switch -regexp -- $conp {
		    {nw|nc|ne|ce|cw|sw|sc|se} {
			$aCanvas delete $ttag
			set txp [expr {$txp + $TExitManager::CDirConP($conp,x) }]
			set typ [expr {$typ + $TExitManager::CDirConP($conp,y) }]
			
			set conExit      [[$aMap getRoom [$cont getXY]] TExitList::getExit $conp]
			set conThickness [$conExit getConThickness]
			set conColor     [$conExit getConColor]
			
			if {$thisThickness == $conThickness} {
			    set actThickness $thisThickness
			    if { [TCoordinate::cmp $this $cont] > 0 } {
				set actColor $conColor 
			    } else {
				set actColor $thisColor 
			    }
			} else {
			    set actThickness [expr {($thisThickness + $conThickness)/2}]
			    if {$thisThickness > $conThickness } {
				set actColor $conColor 
			    } else {
				set actColor $thisColor
			    }
			}

			set ex [$aCanvas create line $axp $ayp $txp $typ \
				    -width $actThickness -fill [TColor::smmToTk $actColor] \
 				    -tag "$atag $ttag"]
		    }
		    default {
			set ex [$aCanvas create line $axp $ayp $txp $typ \
				    -width $thisThickness -fill [TColor::smmToTk $thisColor] \
				    -arrow last \
	 			    -tag "$atag"]
		    }
		}
	    } else {
		foreach id [$aCanvas find withtag $atag] {
		    foreach tt [$aCanvas gettags $id] {
			if {![string compare $tt $atag]} {
			    $aCanvas delete $id
			} else {
			    scan $tt "ec%d,%d,%s" ttx tty ttc
			    $aCanvas delete $id
			    [$aMap getRoom "$ttx,$tty"] draw $aCanvas $aMap
			}
		    }
		}		
	    }
	}
	return $aID
    }
    method drawText {aCanvas xp yp tt aID} {
 	set id [ $aCanvas create text [$CText getDX $xp] [$CText getDY $yp] \
		     -text [$CText dText] -font [$CText font] -fill [$CText color] -tag $tt ]
	$aCanvas raise $id $aID
	return $id
    }
    method drawBG-below {aCanvas xp yp tt} {
	if {[string compare "" [$aCanvas type playerpos]]} {
	    set tagi playerpos
	} else {
	    set tagi grid
	}
 	if {[string match "bg_*_below" [$CBg getType]]} {
	    set bg [$aCanvas create image $xp $yp -tag $tt -image [$CBg getImage] ]
	    $aCanvas lower $bg $tagi
	}
    }
    method drawBG-ontop {aCanvas xp yp tt aID} {
 	if {[string match "bg_*_ontop" [$CBg getType]]} {
	    set bg [$aCanvas create image $xp $yp -tag $tt -image [$CBg getImage] ]
	    $aCanvas raise $bg $aID
	    return $bg
	} else {
	    return $aID
	}
    }
    method drawExitLines {aCanvas xp yp tt} {
	set ex ""
	set ttt "$tt el$tt"
	foreach pos [TExitList::getPoss] {
	    if {[regexp -- {nw|nc|ne|cw|ce|sw|sc|se} $pos]} {
		set xxp [expr {$xp + $TExitManager::CDirConP($pos,x)}]
		set yyp [expr {$yp + $TExitManager::CDirConP($pos,y)}]
		set thisExit [TExitList::getExit $pos]
		set ex [$aCanvas create line $xp $yp $xxp $yyp \
			    -width [$thisExit getConThickness] \
			    -fill  [TColor::smmToTk [$thisExit getConColor]] -tag $ttt]
		$aCanvas raise $ex grid

		# draw the door
		set thisExit [getExit $pos]
		if {[$thisExit getDoor]} {
		    set ex [$aCanvas create rectangle [expr {$xxp-2}] [expr {$yyp-2}] [expr {$xxp+2}] [expr {$yyp+2}] \
				-width 1 -fill black -tag $ttt]
		    $aCanvas raise $ex grid		    
		}
	    } 
	}
	if {[string compare "" $ex]} {
	    return "el$tt"
	} else {
	    return grid
	}
    }
    method draw {aCanvas aMap} {
	#taglist: grid zoompos playerpos bgontop bgbelow
	set xp [TMap::m2p [getX] 1]
	set yp [TMap::m2p [getY] -1]
	set tt p[getXY]
	
	$aCanvas delete $tt

	#draw above grid
	set ELID [drawExitLines       $aCanvas $xp $yp $tt]
	set BGOT [drawBG-ontop        $aCanvas $xp $yp $tt $ELID]
	set SID  [drawStuff           $aCanvas $xp $yp $tt $BGOT]
	set EID  [drawExitIcons       $aCanvas $xp $yp $tt $SID]
	set ECID [drawExitConnections $aCanvas $xp $yp $tt $EID $aMap]
	drawText            $aCanvas $xp $yp $tt $ECID
	#draw below grid/playerpos
	drawBG-below        $aCanvas $xp $yp $tt
    }

    method drawRem {aCanvas aMap} {
	#taglist: grid zoompos playerpos bgontop bgbelow
	set xp [TMap::m2p [getX] 1]
	set yp [TMap::m2p [getY] -1]
	set tt p[getXY]
	
	$aCanvas delete $tt

	set ECID [drawExitConnections $aCanvas $xp $yp $tt grid $aMap]
    }

    method text {}     { return $CText }
    method bg {}       { return $CBg }

}

#########################################################
# order of thiongs drawn on top of each other

# text
# exitconnections
# extraordinary exits
# stuff
# bg-ontop
# exits
# grid
# zoompos
# playerpos
# bg-below


class TRoomUif {
    inherit itk::Widget TRoom

    variable CMapM    ;# parent object
    variable CBGIM
    variable CResetRoom
    variable CResetRoomExists

    variable CChanged
    variable CZoomMap

    method toggle {aWhat} {
	global [getVariable]
	eval set val $[getVariable]([getIndex $aWhat])
	if {$val} {
	    $itk_component(pw) show $aWhat
	} else {
	    $itk_component(pw) hide $aWhat
	}
    }
    method getVariable {}      { return __TRoomUif }
    method getIndex    {aWhat} { return "$this,$aWhat" }

    method showonly {a} {
	global [getVariable]
	set f [$itk_component(pw) getFractions]
	set vvv 0
	foreach w [list exits stuff rest] {
	    eval set val $[getVariable]([getIndex $w])
	    incr vvv $val
	    set [getVariable]([getIndex $w]) 0
	    $itk_component(pw) hide $w
	}
	set [getVariable]([getIndex $a]) 1
	$itk_component(pw) show $a	
	if {$vvv==1} {
	    eval $itk_component(pw) fraction $f
	}
    }

    method getLayout {} {
	global [getVariable]
	set retval [list]
	set slist  [list]
	foreach w [list selector exits stuff rest squeezer] {
	    eval set val $[getVariable]([getIndex $w])
	    lappend slist $val
	}
	lappend retval $slist
	lappend retval [$itk_component(pw) getFractions]
	return $retval
    }
    method setLayout {aLayout} {
	global [getVariable]
	set sl [lindex $aLayout 0]
	set i 0
	foreach w [list selector exits stuff rest squeezer] {
	    if {[lindex $sl $i]} { 
		set [getVariable]([getIndex $w]) 1
		$itk_component(pw) show $w	
	    } else {
		set [getVariable]([getIndex $w]) 0
		$itk_component(pw) hide $w	
	    }	    
	    incr i
	}
	eval $itk_component(pw) fraction [lindex $aLayout 1]
    }

    itk_option define -foreground foreground Foreground black {
	#$itk_component(selexit) configure -foreground $itk_option(-foreground)
    }




    constructor {aParent aBGIM args} {
	global TV
	set wid $itk_interior.f

	set CMapM $aParent
	set CBGIM $aBGIM
	set CResetRoom [TRoom ::\#auto]
	set CResetRoomExists 0

	set CZoomMap ""

	####===========================================================================
	# a frame around all
	itk_component add   pw {
	    iwidgets::panedwindow $wid \
		-orient vertical 
	} {keep -background}
	pack $itk_component(pw) -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left

	$itk_component(pw) add  selector -margin 0
	$itk_component(pw) add  exits    -margin 0
	$itk_component(pw) add  stuff    -margin 0
	$itk_component(pw) add  rest     -margin 0
	$itk_component(pw) add  squeezer -margin 0
	$itk_component(pw) hide selector
	$itk_component(pw) hide squeezer 
	global __TRoomUif
	set __TRoomUif($this,selector) 0
	set __TRoomUif($this,exits)    1
	set __TRoomUif($this,stuff)    1
	set __TRoomUif($this,rest)     1
	set __TRoomUif($this,squeezer) 0

	
	#itk_component add mainframe {frame $wid -relief ridge -bd 0 } {keep -background}
	#pack $itk_component(mainframe) -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0
	# frame for exits, stuff, etc
	#itk_component add   est {frame $wid.est -relief ridge -bd 0 } {keep -background}
	#pack $itk_component(est) -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left
	# frame for x/y and buttons
	#itk_component add   stayframe {frame $wid.but -relief ridge -bd 2 } {keep -background}
	#pack $itk_component(stayframe) -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left

	####===========================================================================
	# selector frame
	itk_component add   self {
	    frame [$itk_component(pw) childsite selector].sel -bd 2 -relief ridge
	} {keep -background}
	pack $itk_component(self) -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0 -side top
# 	itk_component add selsel {
# 	    checkbutton $itk_component(self).sel \
# 		-text "Selector" \
# 		-command [code $this toggle selector] \
# 		-variable "[getVariable]([getIndex selector])" \
# 		-justify left -anchor nw
# 	} { keep -background }
	itk_component add selexit {
	    checkbutton $itk_component(self).exit \
		-text "Exits" \
		-command [code $this toggle exits] \
		-variable "[getVariable]([getIndex exits])" \
		-justify left -anchor nw 
	} {
	    keep -background
	    keep -foreground
	}
	itk_component add selstuff {
	    checkbutton $itk_component(self).stuff \
		-text "Stuff" \
		-command [code $this toggle stuff] \
		-variable "[getVariable]([getIndex stuff])" \
		-justify left -anchor nw 
	} {
	    keep -background 
	    keep -foreground
	}
	itk_component add selmain {
	    checkbutton $itk_component(self).main \
		-text "Main" \
		-command [code $this toggle rest] \
		-variable "[getVariable]([getIndex rest])" \
		-justify left -anchor nw 
	} { 
	    keep -background 
	    keep -foreground
	}
# 	itk_component add selsqueezer {
# 	    checkbutton $itk_component(self).squeezer \
# 		-text "Squeezer" \
# 		-command [code $this toggle squeezer] \
# 		-variable "[getVariable]([getIndex squeezer])" \
# 		-justify left -anchor nw
# 	} { keep -background }
	pack $itk_component(selexit) \
	    $itk_component(selstuff) \
	    $itk_component(selmain) \
	    -side top -fill both -expand 1 -ipadx 0 -ipady 0 -padx 0 -pady 0 
	bind $itk_component(selexit)  <<ZIFShortcut>> [code $this showonly exits]
	bind $itk_component(selstuff) <<ZIFShortcut>> [code $this showonly stuff]
	bind $itk_component(selmain)  <<ZIFShortcut>> [code $this showonly rest]


	# x/y, bg, dev mode, etc

	# xy and bg frame
	itk_component add   xybg {
	    frame [$itk_component(pw) childsite rest].xybg -bd 2 -relief ridge
	} {keep -background}
	pack $itk_component(xybg) -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0 -side top
	# @---@ bg
	itk_component  add bg { 
	    TBGUif $itk_component(xybg).bg $this $CBGIM 
	} {keep -background; keep -foreground}
	pack $itk_component(bg) -side left -fill none -expand false -ipadx 0 -ipady 0 -padx 0 -pady 0 
	# @---@  X and Y
	itk_component  add xy { 
	    TCoordinateUif $itk_component(xybg).xy -orient v -width 4 \
		-command [code $this newCoordinate %x %y] \
		-focuscommand [code $this coordUifGotFocus]
	} {
	    keep -background
	    keep -foreground
	}
	pack $itk_component(xy) -side left -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0 
	$itk_component(xy) redirect [TCoordinate::getNum]
	setXY [$CMapM getActCoord]
	

	# @---@  text
	itk_component add   text  {TTextUif [$itk_component(pw) childsite rest].text $this} {
	    keep -background
	    keep -foreground
	}
	pack $itk_component(text) -fill both -expand yes -side top -anchor nw
	
	# buttons frame
	itk_component add   butf {frame [$itk_component(pw) childsite rest].buttons -bd 0 } {keep -background}
	pack $itk_component(butf) -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0 -side top
	# buttons
	itk_component add   res {
	    button $itk_component(butf).res -text "Reset" -width 5 \
		-command [code $this resetit] 
	} {
	    keep -background
	    keep -foreground
	}
	pack $itk_component(res) -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left
	itk_component add   acc {
	    button $itk_component(butf).acc -text "Accept" -width 5 \
		-command [code $this accept] 
	} {
	    keep -background
	    keep -foreground
	}
	pack $itk_component(acc) -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left


	####===========================================================================
	# exits, stuff, text
	# @---@ exits
	itk_component add   exits {
	    TExitListUif [$itk_component(pw) childsite exits].exit $this $CMapM $CBGIM
	} {
	    keep -background
	    keep -foreground
	}
	pack $itk_component(exits) -fill both -expand yes -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left
	# @---@ stuff
	itk_component add   stuff {
	    TStuffListUif [$itk_component(pw) childsite stuff].stuff $this $CBGIM
	} {
	    keep -background
	    keep -foreground
	}
	pack $itk_component(stuff) -fill both -expand yes -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left


	unchanged
	
	eval itk_initialize $args

	$itk_component(pw) fraction 46 21 33

    }
    method changed {} {
	set CChanged 1
	$itk_component(res) configure -state normal
	$itk_component(acc) configure -state normal
    }
    method zifSetBg {aImo} {
	$itk_component(bg) setBG $aImo
    }
    method zifSetStuff {aPos aImo} {
	$itk_component(stuff) add $aPos $aImo
    }
    method zifRemStuff {aPos} {
	$itk_component(stuff) rem $aPos
    }
    method zifRemExit {aPos} {
	$itk_component(exits) rem $aPos
    }
    method zifSetExit {aExit} {
	$itk_component(exits) add $aExit
    }
    method zifSetText {aText} {
	$itk_component(text) zifSetText $aText
    }
    method zifRemText {} {
	$itk_component(text) clearUif
    }
    method unchanged {} {
	set CChanged 0
	$itk_component(res) configure -state disabled
	$itk_component(acc) configure -state disabled
    }
    method hasChanged {} { return $CChanged }


    method mayEdit {} { return [$CMapM hasMap] }
    method hasMap {} { return [$CMapM hasMap] }
    method newCoordinate {x y} {
	if {![hasMap]} {
	    TInformer $itk_interior.mess \
		-vanishafter 2 \
		-information "No map available!"
	    return
	}
	set map [$CMapM getActMap]
	$CMapM newPlayerPos $map $x $y
	$CMapM newZoomPos   $map $x $y
	focus $itk_component(res)
    }
    method coordUifGotFocus {} {
	if {![hasMap]} {
	    focus $itk_component(res)
	    TInformer $itk_interior.mess \
		-vanishafter 2 \
		-information "No map available!"
	    return
	}	
    }
    method textRem {} {
	$CText rem
	changed
    }
    method textSet {} {
	$CText = $itk_component(text)
	changed
    }
    method setBG {imo} { 
	set CBg $imo
	changed
    }
    method createTheRoom {} {
	$itk_component(bg) createTheRoom
	changed
    }
    method removeTheRoom {} {
	$itk_component(exits) clearUif
	$itk_component(stuff) clearUif
	$itk_component(text)  clearUif
	set CBg ""
	changed
    }
    method exists {} {
	return [string compare "" $CBg]
    }
    method resetit {} {
	if {$CResetRoomExists} {
	    setUifBase $CResetRoom
	} else {
	    clearUif
	    unchanged
	}
    }
    method resetUif {aMap aX aY} {
	set CZoomMap $aMap
	set CResetRoomExists 0
	setXY $aX $aY
	clearUif
	unchanged
    }
    method setUif {aRoom aMap} {
	set CResetRoomExists 1
	$CResetRoom TRoom::= $aRoom
	setUifBase $aRoom
	set CZoomMap $aMap
    }
    method setUifBase {aRoom} {
	clearUif
	setXY $aRoom
	$itk_component(bg)    setUif $aRoom
	$itk_component(exits) setUif $aRoom
	$itk_component(stuff) setUif $aRoom
	$itk_component(text)  setUif $aRoom
	unchanged
    }
    method clearUif {} {
	$itk_component(exits) clearUif
	$itk_component(stuff) clearUif
	$itk_component(text)  clearUif
	$itk_component(bg)    clearUif
    }
    method setXY {args} {
	switch [llength $args] {
	    1 { $itk_component(xy) TCoordinate::= $args
	    }
	    2 { $itk_component(xy) TCoordinate::setX [lindex $args 0]
		$itk_component(xy) TCoordinate::setY [lindex $args 1]
	    }
	}
    }
    method accept {} {	
	if {[$itk_component(bg) exists]} {
	    $CMapM addRoom $this $CZoomMap
	} else {
	    $CMapM remRoom $this $CZoomMap
	}
	unchanged
    }

}






# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TRoom.tcl,v $
# Revision 1.6  2002/04/21 18:03:16  issever
# made ccp und dnd much smarter about exits leading to
# and coming from other maps.
#
# Revision 1.5  2002/04/04 21:07:03  issever
# Optimized the expr's, which are used in the mapping code.
# Splited the File TEXit.tcl.
#
# Revision 1.4  2002/02/11 20:24:32  issever
# cut/copy/paste for maps, drag&drop, code cleanup of mapmanager
#
# Revision 1.3  2001/11/25 20:30:33  issever
# Removed the -foreground bug.
# This was a quite widespread bug and I hope I caught
# every appereance. If I've missed one, please notify
# us again.
#
# Revision 1.2  2001/08/19 12:25:42  issever
# Added the cvs keywords Id at start of the file
# and Log at the end of the file
#
#
