# $Id: TStuffList.tcl,v 1.3 2001/11/25 20:30:33 issever Exp $

# Class TStuff is unnecessary, as TStuff will be a TIMAGE 
class TStuffList {
    variable CStuffList
    common   CPosList {nw nc ne cw cc ce sw sc se}
    private common CGrid 32

    # null: creates, StuffList: creates and copies
    constructor {args} {}
    method add {aPos aStuff} 
    method rem {aPos} 
    method getPoss {} 
    method getStuff {aPos}
    method exists {aPos}
    method = {source} 

    method streamout {} {
	set il [list]
	foreach pos [TStuffList::getPoss] {
	    lappend il [list $pos [[getStuff $pos] streamout]]
	}
	return $il
    }
    method streamin {arg imm} {
	foreach ss $arg {
	    set pos    [lindex $ss 0]
	    set stuff  [$imm streamin [lindex $ss 1]]
	    TStuffList::add $pos $stuff
	}
    }
    proc getXOff {aPos} {
	set xpos [string index $aPos 1]
	switch $xpos {
	    w { return [expr -0.25*$CGrid]  }
	    c { return 0  }
	    e { return [expr 0.25*$CGrid]  }
	}	
    }
    proc getYOff {aPos} {
	set ypos [string index $aPos 0]
	switch $ypos {
	    n { return [expr -0.25*$CGrid]  }
	    c { return 0  }
	    s { return [expr 0.25*$CGrid]  }
	}	
    }
}

#------------------------------------------------------------------
class TStuffListUif {
    inherit itk::Widget
    itk_option define -foreground foreground Foreground black {
	#$itk_component(selexit) configure -foreground $itk_option(-foreground)
    }

    variable CDefList              ;# Object of type TStuffList
    variable CIMM
    variable CSelector
    variable CParent
    
    private variable CBGColor     "\#daceaf"
    private variable CBGDarkColor "\#a97"

    method clearUif {} {
	foreach ns {n c s} { foreach we {w c e} { rem $ns$we } }
    }
    method setUif {aRoom}  { 
	clearUif 
	$CParent TStuffList::= $aRoom
	foreach pos [$aRoom TStuffList::getPoss] {
	    $itk_component(b$pos) configure -image [[$CParent getStuff $pos] getImage]
	}
    }
    method setDefStuff {pos imo} {
	$CDefList add $pos $imo
    }
    method add {pos imo} {
	$CParent changed
	$CParent createTheRoom
	$CParent TStuffList::add $pos $imo
	$itk_component(b$pos) configure -image [$CIMM getImage [$imo getType] [$imo getCategory] [$imo getName]]
    }
    method rem {aPos} {
	$CParent changed
	$CParent TStuffList::rem $aPos
	$itk_component(b$aPos) configure -image [$CIMM getImage system stuff none]
    }

    method shortCutAction {aPos} {
	if {![$CParent hasMap]} {
	    TInformer $itk_interior.mess \
		-vanishafter 2 \
		-information "No map available!"
	    return
	}
	if {[$CParent TStuffList::exists $aPos]} {
	    rem $aPos
	} else {
	    add $aPos [$CDefList getStuff $aPos]
	}
    }

    constructor {aParent aIMM args} {
	set CIMM $aIMM
	set CDefList [TStuffList ::\#auto]
	regsub -- {^::} $aParent {} CParent	
	
	itk_component add mainframe {frame $itk_interior.mf -relief ridge -bd 2 } {keep -background}
	pack $itk_component(mainframe) -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0

	# buttons
	foreach ns {n c s} {
	    itk_component   add bf$ns {frame $itk_component(mainframe).$ns -relief flat -bd 0} {usual}
	    pack $itk_component(bf$ns) -fill both -expand true -side top
	    
	    foreach we {w c e} {
		itk_component add b$ns$we { 
		    button $itk_component(mainframe).$ns.$we -bg $CBGColor \
			-width 20 -height 25
		} {
		    ignore -background
		    keep -foreground
		}
		pack $itk_component(b$ns$we) -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left -fill both -expand 1
		bind $itk_component(b$ns$we) <<ZIFExtended>>       "[code $this launchUIF $ns$we]"
		bind $itk_component(b$ns$we) <<ZIFShortcut>>       "[code $this shortCutAction $ns$we]"
		
		setDefStuff $ns$we [$CIMM getObject stuff misc stuff]
		rem $ns$we
	    }
	}
	set CSelector $itk_interior.selector
	itk_component add selec {
	    TStuffSelector $CSelector $this $CIMM \
		-master [winfo toplevel $itk_interior] \
		-tops [winfo toplevel $itk_interior] 
	} {
	    keep -foreground
	    keep -background
	}

	eval itk_initialize $args
    }

    method launchUIF {aPos} {
	if {![$CParent hasMap]} {
	    TInformer $itk_interior.mess \
		-vanishafter 2 \
		-information "No map available!"
	    return
	}
	$CSelector setActPos $aPos
	$CSelector activate 
    }
}

#####################################################################


###############################################################
class TStuffSelector {
    inherit iwidgets::Shell

    variable CIM
    variable CParent
    variable CActPos

    variable CSetMode 

    method setActPos {aPos} {
	set CActPos $aPos
	if {$CSetMode} {
	    defaultMode
	} else {
	    chooseDefStuffMode
	}
    }
    constructor {aParent aIM args} {
	set CActPos ""
	set CIM    $aIM
	regsub -- {^::} $aParent {} CParent
	
	configure -modality application

	set wid [$this childsite]
	$wid configure -relief ridge -bd 0

	# create buttons
	itk_component add   butframe {frame $wid.butframe -relief ridge -bd 2 } {keep -background}
	pack $itk_component(butframe) -side bottom -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0

	itk_component add   defstuff {
	    button $itk_component(butframe).defstuff -width 15 -text "set def. stuff" -command "[code $this defstuff]"
	} {keep -background;keep -foreground}
	pack $itk_component(defstuff) -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left
	itk_component add   rem {
	    button $itk_component(butframe).rem -width 15 -text "remove" -command "[code $this remove]"
	} {keep -background;keep -foreground}
	pack $itk_component(rem) -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left
	itk_component add   canc {
	    button $itk_component(butframe).canc -width 15 -text "cancel" -command "[code $this canc]"
	} {keep -background;keep -foreground}
	pack $itk_component(canc) -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left
	
	# descriptor
	itk_component add   dframe {frame $wid.dframe -relief ridge -bd 2 } {keep -background}
	pack $itk_component(dframe) -side bottom -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0
	itk_component add   desc   { 
	    label $itk_component(dframe).l -justify center -textvariable _TBGSelector($this,l) \
		-font bigBold -background $TColor::BGlight -width 60
	} { ignore -background ; keep -foreground}
	pack $itk_component(desc) -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left
	
	# go into default "set stuff" mode
	defaultMode

	# create stuff buttons
	set c 0
	set io 0
	foreach type [list stuff stuff_XL] {
	    foreach category [$CIM getCategories $type] {
		itk_component  add c$c { frame $wid.c$c -relief ridge -borderwidth 2 }
		pack $itk_component(c$c) -fill both -expand true -padx 0 -pady 0 -side top
		foreach imobj [$CIM getObjects $type $category] {
		    itk_component   add but$io { 
			button $itk_component(c$c).but$io  -image [$imobj getImage] \
				-command "[code $this selectStuff $imobj]"
		    } {keep -background;keep -foreground}
		    pack $itk_component(but$io) -side left -fill none -expand false \
			    -ipadx 0 -ipady 0 -padx 0 -pady 0 
		    bind $itk_component(but$io) <Enter> "[code $this setText $imobj]"
		    bind $itk_component(but$io) <Leave> "[code $this remText]"
		    incr io
		}
		incr c
	    }
	}
	eval itk_initialize $args
    }
    method remText {} {
	global _TBGSelector
	set _TBGSelector($this,l) ""
    }
    method setText {imo} {
	global _TBGSelector
	set _TBGSelector($this,l) "[$imo getType] [$imo getCategory] [$imo getName]"
    }
    method remove {} {
	$CParent rem $CActPos
	canc
    }
    method defstuff {} {
	if {$CSetMode} {
	    chooseDefStuffMode
	} else {
	    defaultMode
	}
    }
    method chooseDefStuffMode {} {
	set CSetMode 0
	configure -title "Default Stuff Selection: $CActPos"
	$itk_component(defstuff) configure -text "choose stuff  " 
   }
    method defaultMode {} {
	configure -title "Stuff Selection: $CActPos"
	$itk_component(defstuff) configure -text "set def. stuff" 
	set CSetMode 1
    }
    method canc {} { 
	defaultMode
	$this deactivate 
    }
    method selectStuff {imo} {
	if {$CSetMode} {
	    $CParent add  $CActPos $imo
	} else {
	    $CParent setDefStuff  $CActPos $imo
	}
	canc
    }

}
###############################################################################################################


body TStuffList::constructor {args} {
    switch [llength $args] {
	0 {		
	}
	1 {
	    TStuffList::= $args
	}
	default {
	    error "Wrong numer of arguments to constructor!"
	}
	
    }	
}

body TStuffList::add {aPos aStuff} {
    TStuffList::rem $aPos
    set CStuffList($aPos) $aStuff
}
body TStuffList::rem {aPos} {
    if {[info exists CStuffList($aPos)]} {
	unset CStuffList($aPos)
    }
}
body TStuffList::getPoss {} {
    return [array names CStuffList]
}
body TStuffList::exists {aPos} {
    return [info exists CStuffList($aPos)]
}
body TStuffList::getStuff {aPos} {
    return $CStuffList($aPos)
}

body TStuffList::= {source} {
    foreach pos $CPosList {
	TStuffList::rem $pos
    }
    foreach pos [$source TStuffList::getPoss] {
	TStuffList::add $pos [$source TStuffList::getStuff $pos]
    }
}









# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TStuffList.tcl,v $
# Revision 1.3  2001/11/25 20:30:33  issever
# Removed the -foreground bug.
# This was a quite widespread bug and I hope I caught
# every appereance. If I've missed one, please notify
# us again.
#
# Revision 1.2  2001/08/19 12:25:42  issever
# Added the cvs keywords Id at start of the file
# and Log at the end of the file
#
#
