# $Id: TText.tcl,v 1.3 2001/11/25 20:30:33 issever Exp $

class TText {
    inherit TCoordinate
    
    private variable CText        ""
    private variable CFont        {Courier 12 normal}
    private variable COrientation "hori"
    private variable CColor       "black"

    constructor {args} {
	TCoordinate::constructor 0 0.25
    } {
	switch [llength $args] {
	    0 {	
	    }
	    1 {
		TText::= $args
	    }
	    5 {
		set CText                [lindex $args 0]
		TCoordinate::=           [lindex $args 1]
		set CFont                [lindex $args 2]
		set COrientation         [lindex $args 3]
		set CColor               [lindex $args 4]
	    }
	    default {
		error "Wrong numer of arguments to constructor!"
	    }
	    
	}
    }
    private common CSMMNL  "\n"      ; # newlines converted to
    private common CFileNL "\x1bn"   ; # ESC n
    method streamout {} {
	regsub -all -- $CSMMNL $CText $CFileNL outText
	return [list [TCoordinate::streamout] $CFont $COrientation $CColor $outText]
    }
    method streamin {arg} {
	TCoordinate::streamin [lindex $arg 0]
	set CFont        [lindex $arg 1]
	set COrientation [lindex $arg 2]
	set CColor       [lindex $arg 3]
	set CText        [lindex $arg 4]
	regsub -all -- $CFileNL $CText $CSMMNL CText
    }
    method rem {} {
	set CText           ""
	set CFont           {Courier 12 normal}
	set COrientation    "hori"
	set CColor          "black"
	setXY 0 0.25
    }
    method settext     {aText} {set CText $aText}

    method text        {} { return $CText}
    method font        {} { return $CFont}
    method orientation {} { return $COrientation}
    method horizontal  {} { return [string compare $COrientation "vert"] }
    method color       {} { return $CColor}
    method = {source} {
	set CText           [$source text]
	set CFont           [$source font]
	set COrientation    [$source orientation]
	set CColor          [$source color]
	TCoordinate::=      $source
    }
    method dText {} {
	if {[horizontal]} {
	    return $CText
	} else {
	    set i 0
	    set l [expr [string length $CText]-1]
	    while {$i<$l} {
		append mm "[string index $CText $i]\n"
		incr i
	    }
	    append mm "[string index $CText $i]"
	    return $mm
	}
    }
    method getDX {aXOff} {
	return [expr $aXOff + [getX]*$TGUI::grid]
    }
    method getDY {aYOff} {
	return [expr $aYOff - [getY]*$TGUI::grid]
    }

}


#------------------------------------------------------------------
class TTextUif {
    inherit itk::Widget TText

    private variable CSelector
    private variable CParent

    itk_option define -foreground foreground Foreground black {
	#$itk_component(selexit) configure -foreground $itk_option(-foreground)
    }
    constructor {aParent args} {
	global _TTextUif

	regsub -- {^::} $aParent {} CParent	
	
	itk_component   add label { 
	    label $itk_interior.label -text "text: " 
	} { 
	    keep -background 
	    keep -foreground
	} 
	pack $itk_component(label) -fill y -expand 0 -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left
	itk_component   add entry {
	    entry $itk_interior.entry -width 3 -background $TColor::BGlight
	} {
	    ignore -background
	    keep -foreground
	}
	pack $itk_component(entry) -fill both -expand 1 -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left

	bind $itk_component(entry) <Key>         "[code $this createTheRoom]"
	bind $itk_component(entry) <KeyRelease>  "[code $this createTheRoom]"
	bind $itk_component(entry) <Return>      "[code $this finished]"
	bind $itk_component(entry) <FocusIn>     "[code $this checkMapAvailibility]"

	bind $itk_component(label) <<ZIFExtended>>    "[code $this launchUIF]"

	set CSelector $itk_interior.selector
	TTextSelector $CSelector $this \
	    -master [winfo toplevel $itk_interior] \
	    -tops [winfo toplevel $itk_interior] 

	eval itk_initialize $args
    }
    method finished {} {
	if {![$CParent hasMap]} {
	    TInformer $itk_interior.mess \
		-vanishafter 2 \
		-information "No map available!"
	    return
	}
	focus $itk_component(label)
    }
    method checkMapAvailibility {} {
	if {![$CParent hasMap]} {
	    focus $itk_component(label)
	    TInformer $itk_interior.mess \
		-vanishafter 2 \
		-information "No map available!"
	    return
	}
    }
    method createTheRoom {} {
	if {![$CParent hasMap]} {
	    TInformer $itk_interior.mess \
		-vanishafter 2 \
		-information "No map available!"
	    rem
	    return
	}
	settext [$itk_component(entry) get]
	$CParent createTheRoom
	$CParent textSet
    }
    method = {source} {
	TText::= $source
	$itk_component(entry) delete 0 end
	$itk_component(entry) insert 0 [text]
	createTheRoom
    }
    method zifSetText {aText} {
	settext $aText
	$itk_component(entry) delete 0 end
	$itk_component(entry) insert 0 $aText
	createTheRoom
    }
    method rem {} {
	TText::rem
	$itk_component(entry) delete 0 end
	$CParent textRem
    }
    method launchUIF {} {
	if {![$CParent hasMap]} {
	    TInformer $itk_interior.mess \
		-vanishafter 2 \
		-information "No map available!"
	    return
	}
	settext [$itk_component(entry) get]
	$CSelector updateUif
	$CSelector activate 
    }
    method clearUif {} {
	rem 
    }
    method setUif {aRoom} {
	clearUif
	= [$aRoom text]
    }
}

#------------------------------------------------------------------
class TTextSelector { 
    inherit iwidgets::Shell

    variable CParent

    constructor {aParent args} {
	global TV
	regsub -- {^::} $aParent {} CParent

	set wid [$this childsite]
	$wid configure -relief ridge -bd 0

	configure -title "Configure Room Text"
	configure -modality application

	#########################################################################
	# create buttons
 	itk_component add   butframe {frame $wid.butframe -relief ridge -bd 2 } {keep -background}
 	pack $itk_component(butframe) -side bottom -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0

 	itk_component add   ok {
 	    button $itk_component(butframe).ok -width 10 -text "OK" -command "[code $this OK]"
 	} {keep -background}
 	itk_component add   rem {
 	    button $itk_component(butframe).rem -width 10 -text "remove" -command "[code $this remove]"
 	} {keep -background}
 	itk_component add   canc {
 	    button $itk_component(butframe).canc -width 10 -text "cancel" -command "[code $this canc]"
 	} {keep -background}
 	pack $itk_component(ok) $itk_component(rem) $itk_component(canc) \
 	    -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left

	############## top frame
	itk_component   add topframe {frame $wid.topf \
					   -relief ridge -bd 2 } {keep -background}
	pack $itk_component(topframe) -fill x -expand 0 -ipadx 0 -ipady 0 -padx 0 -pady 0 -side top

	######## text frame
	itk_component   add textf {
	    iwidgets::labeledframe $itk_component(topframe).textf -labeltext "text" 
	} {keep -background}
	pack $itk_component(textf) -fill both -expand 1 -ipadx 0 -ipady 0 -padx 0 -pady 0 -side bottom	
 	itk_component   add text {
	    iwidgets::scrolledtext [$itk_component(textf) childsite].text \
		-hscrollmode dynamic -vscrollmode dynamic \
		-wrap none -borderwidth 2 -relief sunken -visibleitems 40x7
 	} {keep -background}
 	pack $itk_component(text) -fill both -expand 1 -side bottom -anchor nw

	######## font
	itk_component   add fontf {
	    iwidgets::labeledframe $itk_component(topframe).font -labeltext "font" 
	} {keep -background}
	pack $itk_component(fontf) -fill both -expand 1 -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left

	itk_component   add fontuif {
	    TFontUif [$itk_component(fontf) childsite].fu 
	} {keep -background}
	pack $itk_component(fontuif) -fill x -expand 0 -ipadx 0 -ipady 0 -padx 0 -pady 0 -side top	

	############## ori/off/color frame
	itk_component   add oocframe {frame $itk_component(topframe).ooc \
					   -relief ridge -bd 0 } {keep -background}
	pack $itk_component(oocframe) -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left

	######## color
	itk_component   add colorf {
	    iwidgets::labeledframe $itk_component(oocframe).colorf -labeltext "color" 
	} {keep -background}
	pack $itk_component(colorf) -fill both -expand 1 -ipadx 0 -ipady 0 -padx 0 -pady 0 -side bottom

	itk_component   add color { 
	    iwidgets::combobox [$itk_component(colorf) childsite].c \
		-editable 0 -width 10 -textvariable TV($this,color) 
	} {keep -background}
 	pack $itk_component(color) -fill both -expand 1 -side left -anchor nw
	$itk_component(color) insert list end \
	   black red green blue white

	######## orientation
	itk_component   add butori {
	    iwidgets::radiobox $itk_component(oocframe).ori \
		-labeltext "orient." -labelpos nw 
	    #-selectcolor red
	} {keep -background}
	pack $itk_component(butori) -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left
	$itk_component(butori) add hori -text "horizontal"
	$itk_component(butori) add vert -text "vertical"
	$itk_component(butori) select hori

	######## offset
	itk_component   add off {
	    iwidgets::labeledframe $itk_component(oocframe).off -labeltext "offset" 
	} {keep -background}
	pack $itk_component(off) -fill both -expand 1 -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left	

	itk_component   add offxy { 
	    TCoordinateUif [$itk_component(off) childsite].xy -orient v -validate real -width 5
	} {keep -background}
 	pack $itk_component(offxy) -fill x -expand 1 -side left -anchor nw


	eval itk_initialize $args
    }
    method canc {} { 
	$this deactivate 
    }
    method remove {} {
	$CParent rem 
	canc
    }
    method OK {} {
	global TV

	set text [string trim [$itk_component(text) get 1.0 end]]
	if {![string compare $text ""]} {
	    TInformer $itk_interior.mess \
		-information "You have to give a 'text'!\nOtherwise remove the text."
	    return
	}

	set tt [TText ::\#auto \
		    $text \
		    $itk_component(offxy) \
		    [$itk_component(fontuif) getFont] \
		    [$itk_component(butori) get] \
		    $TV($this,color) ]

	$CParent = $tt
	::delete object $tt

	canc
    }
    method updateUif {} {
	global TV 
	$itk_component(text) clear
	$itk_component(text) insert end [$CParent text]
	$itk_component(offxy) = $CParent
	$itk_component(fontuif) setFont [$CParent font]
	$itk_component(butori) select [$CParent orientation]
	set TV($this,color) [$CParent color]
    }
}

##########################################################################################
##########################################################################################





# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TText.tcl,v $
# Revision 1.3  2001/11/25 20:30:33  issever
# Removed the -foreground bug.
# This was a quite widespread bug and I hope I caught
# every appereance. If I've missed one, please notify
# us again.
#
# Revision 1.2  2001/08/19 12:25:42  issever
# Added the cvs keywords Id at start of the file
# and Log at the end of the file
#
#
