# $Id: TButton.tcl,v 1.2 2001/08/19 12:25:42 issever Exp $

class TButtonArea {
    inherit iwidgets::Scrolledframe

    variable CRowList

    constructor { args } {
	configure -borderwidth 2 
	configure -relief ridge 
	configure -vscrollmode dynamic 
	configure -hscrollmode dynamic 
	set CRowList [list]
	eval itk_initialize $args
    }
    method clear {} { foreach wid $CRowList { destroy $wid } }

    #
    # row's
    #
    method addButtonRow { aRowName } {
	#rows start with row
	set wid [childsite].row$aRowName
	itk_component add row,$aRowName { frame $wid -borderwidth 2 -relief ridge } {keep -background}
	pack $itk_component(row,$aRowName) -side top -expand 0 -fill x -ipadx 0 -ipady 0 -anchor nw
	lappend CRowList $itk_component(row,$aRowName)
    }
    method remButtonRow { aRowName } {
	destroy $itk_component(row,$aRowName)
    }

    #
    # buttons
    #
    method addButton {aRowName aButtonName aText aCom} {
	# buttons start with but
	set wid $itk_component(row,$aRowName).but$aButtonName
	itk_component   add but,$aRowName,$aButtonName { 
	    button $wid -text $aText -command $aCom -font small 
	} {keep -background}
	pack $itk_component(but,$aRowName,$aButtonName) -side left -expand 0 -fill y -ipadx 0 -ipady 0 -anchor nw
    }
    method remButton {aRowName aButtonName} {
	#if {![info exists itk_component(but,$aRowName,$aButtonName)]} { return 0 }
	destroy $itk_component(but,$aRowName,$aButtonName)
	#return 1
    }

    #
    # buttons
    #
    method addCheckbutton {aRowName aButtonName aText aCom aVarName} {
	# buttons start with cbut
	set wid $itk_component(row,$aRowName).cbut$aButtonName
	itk_component   add cbut,$aRowName,$aButtonName { 
	    checkbutton $wid -text $aText -command $aCom -font small -variable ::smm::ses::$aVarName 
	} {keep -background}
	pack $itk_component(cbut,$aRowName,$aButtonName) -side left -expand 0 -fill y -ipadx 0 -ipady 0 -anchor nw
    }
    method remCheckbutton {aRowName aButtonName} {
	#if {![info exists itk_component(but,$aRowName,$aButtonName)]} { return 0 }
	destroy $itk_component(cbut,$aRowName,$aButtonName)
	#return 1
    }

    # 
    # labels
    #
    method addLabel {aRowName aLabelName aText aWidth} {
	# labels start with lab
	set wid $itk_component(row,$aRowName).lab$aLabelName
	itk_component   add lab,$aRowName,$aLabelName { 
	    label $wid -text $aText -width $aWidth -font small -justify left -anchor w \
		-borderwidth 2 
	} {keep -background}
	pack $itk_component(lab,$aRowName,$aLabelName) -side left -expand 0 -fill y -ipadx 0 -ipady 0 -anchor nw
    }
    method remLabel {aRowName aLabelName} {
	destroy $itk_component(lab,$aRowName,$aLabelName)
    }
    method setLabelText {aRowName aLabelName aText} {
	$itk_component(lab,$aRowName,$aLabelName) configure -text $aText
    }

    #
    # varentry
    #
    method addVarEntry {aRowName aName aVarName aWidth } {
	# varentries start with ven
	set wid $itk_component(row,$aRowName).ven$aName
	itk_component   add ven,$aRowName,$aName {
	    entry $wid -font small -textvariable ::smm::ses::$aVarName -width $aWidth \
		-borderwidth 2 -justify left
	} {keep -background}
	pack $itk_component(ven,$aRowName,$aName) -side left -expand 0 -fill y -ipadx 0 -ipady 0 -anchor nw
    }
    method remVarEntry {aRowName aName} {
	destroy $itk_component(ven,$aRowName,$aName)
    }

    #
    # varlabel
    #
    method addVarLabel {aRowName aName aVarName aWidth } {
	# varlabels start with vla
	set wid $itk_component(row,$aRowName).vla$aName
	itk_component   add vla,$aRowName,$aName {
	    label $wid -font small -textvariable ::smm::ses::$aVarName -width $aWidth \
		-relief ridge -borderwidth 2 -justify left -anchor w
	} {keep -background}
	pack $itk_component(vla,$aRowName,$aName) -side left -expand 0 -fill y -ipadx 0 -ipady 0 -anchor nw
    }
    method remVarLabel {aRowName aName} {
	destroy $itk_component(vla,$aRowName,$aName)
    }

    #
    # varchooser
    #
    method addVarChooser {aRowName aName aVarName aWidth } {
	# varchooser start with vch
	set wid $itk_component(row,$aRowName).vch$aName
	itk_component   add vch,$aRowName,$aName {
	    iwidgets::combobox $wid -textfont small -width $aWidth -textvariable ::smm::ses::$aVarName \
		-unique true
	} {keep -background}
	pack $itk_component(vch,$aRowName,$aName) -side left -expand 0 -fill y -ipadx 0 -ipady 0 -anchor nw
    }
    method remVarChooser {aRowName aName} {
	destroy $itk_component(vch,$aRowName,$aName)
    }
    method addVarChooserItem {aRowName aName aItem} {
	$itk_component(vch,$aRowName,$aName) insert list end $aItem
    }
    method remVarChooserItem {aRowName aName aIndex} {
	$itk_component(vch,$aRowName,$aName) delete list $aItem $aItem
    }
}



# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TButton.tcl,v $
# Revision 1.2  2001/08/19 12:25:42  issever
# Added the cvs keywords Id at start of the file
# and Log at the end of the file
#
#
