# $Id: TEntryX.tcl,v 1.3 2001/11/25 20:30:33 issever Exp $

class TEntryX {
    inherit itk::Widget

    #
    # bind keybord events
    #
    private {
	variable _keyArray
	method   _removeAllBindings {} {
	    foreach seq [array names _keyArray] {
		bind $itk_component(com) $seq {}
		unset _keyArray($seq) 
	    }
	}
    }
    method bindevent {seq com} {
	if {[string length $com]!=0} {
	    set _keyArray($seq) $com
	    bind $itk_component(com) $seq $com
	} else {
	    unset _keyArray($seq) 
	    bind $itk_component(com) $seq {}
	}
    }

    #
    # tabbing
    #
    private {
	variable _tabPos
	variable _tabCycle
	variable _tabBegString
	variable _tabEndString
	variable _tabComplSubList
	method   _resetTabCycle {} { set _tabCycle 0 }
	method   _tabCompletition {} 
    }

    #
    # command fifo
    #
    private {
	variable _commandFIFO ;# object
	method   _initCommandFifo {} {
	    set _commandFIFO       [TLimitedFIFO \#auto 20]
	}
	method   _prevMudCom {} {
	    global _TEntryX
	    set _TEntryX($this) [$_commandFIFO getUp]
	    $itk_component(com) icursor end	
	    _resetTabCycle
	}
	method   _nextMudCom {} {
	    global _TEntryX
	    set _TEntryX($this) [$_commandFIFO getDown]
	    $itk_component(com) icursor end	
	    _resetTabCycle
	}
    }
    method resizeHist {aSize} { $_commandFIFO resize $aSize }

    #
    # session
    #
    private {
	variable _ses
	method   _initSes {} {	set _ses     "" }
    }
    method unbindFromSes {} {
	set _ses ""
	_removeAllBindings
    }
    method bindToSes {aSes} { set _ses $aSes }
    method isBoundToSes {} {
	if {[string compare "" $_ses]} { return 1 } else { return 0 }
    }

    #
    # show/hide input
    #
    private {
	variable _showInput
	method   _initShowHide {} { set _showInput 1 }
    }
    method hideInput {} { 
	set _showInput 0 
	$itk_component(com) configure -show *
    } 
    method showInput {} { 
	set _showInput 1 
	$itk_component(com) configure -show ""
    } 

    #
    # constructor and the like
    #
    itk_option define -foreground foreground Foreground black {
	#$itk_component(selexit) configure -foreground $itk_option(-foreground)
    }
    constructor {args} {
	# init
	_initSes
	_initShowHide
	
	_resetTabCycle
	_initCommandFifo

	# build and config widgets
	global _TEntryX		
	itk_component add com {
	    entry  $itk_interior.com -textvariable _TEntryX($this) -bd 2 \
		-font mudDef -fg $TColor::FGCom -bg $TColor::BGCom
	} {ignore -background}
	pack $itk_component(com) -fill both -expand 1 -ipadx 0 -ipady 0 -padx 0 -pady 0 -side top

	bind $itk_component(com)  <Any-KeyPress>          [code $this _evalKeyPress]
	bind $itk_component(com)  <Return>                [code $this _processMudCom]
	bind $itk_component(com)  <KeyPress-Up>           [code $this _prevMudCom]
	bind $itk_component(com)  <KeyPress-Down>         [code $this _nextMudCom]
	bind $itk_component(com)  <KeyPress-Tab>          [code $this _tabCompletition]
	bind $itk_component(com)  <Control-KeyPress-Tab>  [code $this _insertTab]
	
	eval itk_initialize $args
    }
    private {
	method _insertTab {} {
	    $itk_component(com) insert insert "\t"
	    _resetTabCycle
	}
	method _evalKeyPress {} {
	    _resetTabCycle
	}
	method _processMudCom {} {
	    global _TEntryX
	    
	    if {[isBoundToSes]} {
		$_ses toSMM $_TEntryX($this)
		if {$_showInput} {
		    # only insert into fifo, if command may be shown too
		    $_commandFIFO insert $_TEntryX($this)
		}
		set _TEntryX($this) ""
		_resetTabCycle
	    } else {
		TInformer $itk_interior.mess \
		    -vanishafter 3 -information "There is no active Session!"
	    }
	}
    }
    method takeFocus {} { focus $itk_component(com) }

}





############################################################################
body TEntryX::_tabCompletition {} {
    global _TEntryX

    set currentInput $_TEntryX($this)

    if {$_tabCycle>0} {

	set _TEntryX($this) "$_tabBegString[lindex $_tabComplSubList $_tabPos]$_tabEndString"
	set insc [string length "$_tabBegString[lindex $_tabComplSubList $_tabPos]"]
	$itk_component(com) icursor $insc

	incr _tabPos
	if { $_tabPos == [llength $_tabComplSubList]} {
	    set _tabPos 0
	} 
	
    } else {
	set  tabComplList [$_ses  getTabs]
	set  actCurPos [$itk_component(com) index insert]
	incr actCurPos -1

	set  i1 [string wordstart $currentInput $actCurPos] 
	set  i2 [expr [string wordend   $currentInput $actCurPos]-1]
	set  i3 [expr [string wordstart $currentInput [string length $currentInput]] -1]
	
	set tabPattern    [string range $currentInput $i1          $i2]
	set _tabBegString [string range $currentInput 0            [expr $i1-1]]
	set _tabEndString [string range $currentInput [expr $i2+1] $i3]

	if {[string compare " " "$tabPattern"] == 0} {
	    set    tabPattern ""
	    append _tabBegString " "
	}
	if {[string compare "\t" "$tabPattern"] == 0} {
	    set    tabPattern ""
	    append _tabBegString "\t"
	}
	
	set _tabComplSubList ""	
	foreach compl $tabComplList {
	    if {[string match "$tabPattern\*" "$compl"]} {
		lappend _tabComplSubList $compl
	    }
	}
	set _tabComplSubList [lsort -ascii -increasing $_tabComplSubList]

	# remove double entries
	for {set i 1} {$i<[llength $_tabComplSubList]} {incr i} {
	    set j [expr $i-1]
	    if {[string match [lindex $_tabComplSubList $i] [lindex $_tabComplSubList $j]]} {
		set _tabComplSubList [lreplace $_tabComplSubList $i $i]
		incr i -1
	    }
	}

	switch -- [llength $_tabComplSubList] {
	    0 {
		$_ses printf "No tab-completition possible!"
		return
	    } 
	    1 {
		set _TEntryX($this) "$_tabBegString[lindex $_tabComplSubList 0]$_tabEndString"	
		set insc [string length "$_tabBegString[lindex $_tabComplSubList 0]"]
		$itk_component(com) icursor $insc
	    }
	    default {
		set sub  [lindex $_tabComplSubList 0]
		set subl [expr [string length $sub] -1]
	
		foreach compl $_tabComplSubList {
		    while {![string match "$sub\*" $compl]} {
			incr subl -1
			set  sub  [string range "$sub" 0 $subl]
		    }
		}

		set _TEntryX($this) "$_tabBegString$sub$_tabEndString"
		$_ses printf "tab-completitions: $_tabComplSubList"
		
		set insc [string length "$_tabBegString$sub"]
		$itk_component(com) icursor $insc
	    }
	}
	
	set _tabCycle 1
	set _tabPos   0
    }
}



############################################################################
###########   E N D   ######################################################
############################################################################







# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TEntryX.tcl,v $
# Revision 1.3  2001/11/25 20:30:33  issever
# Removed the -foreground bug.
# This was a quite widespread bug and I hope I caught
# every appereance. If I've missed one, please notify
# us again.
#
# Revision 1.2  2001/08/19 12:25:42  issever
# Added the cvs keywords Id at start of the file
# and Log at the end of the file
#
#
