# $Id: TMudder.tcl,v 1.2 2001/08/19 12:25:42 issever Exp $

class TMudderUif {
    inherit iwidgets::Panedwindow
    #inherit itk::Widget

    private variable CBMFractions

    itk_option define -foreground foreground Foreground black {
	#$itk_component(selexit) configure -foreground $itk_option(-foreground)
    }
    constructor {aColM args} {
	add buttons -margin 0
	add main -margin 0

	set mwid [childsite main]
	#set mwid $itk_interior
	# mainframe
	itk_component add mainframe {
	    frame $mwid.mainf -background $TColor::BGdef -bd 2 -relief ridge
	} {keep -background}
	pack  $itk_component(mainframe) -side top -expand 1 -fill both -ipadx 0 -ipady 0 -padx 0 -pady 0

	# command input
	itk_component   add input {TEntryX $itk_component(mainframe).input} {
	    ignore -background
	    keep -foreground
	}
	pack $itk_component(input) -fill x -expand 0 -side bottom

	# output text area
	#itk_component   add outputa { frame $itk_component(mainframe).outputa -bd 0 } {keep -background}
	#itk_component   add outputb { frame $itk_component(mainframe).outputb -bd 0 } {keep -background}
	itk_component   add output {
	    TOutX $itk_component(mainframe).output $aColM
	    #TOutX $itk_component(mainframe).output $itk_component(outputa) $itk_component(outputb)
	} {keep -background}
	#pack $itk_component(outputa) -fill x -expand false -side top
	#pack $itk_component(outputb) -fill x -expand false -side bottom
	pack $itk_component(output)  -fill both -expand true -side top
	bind $itk_component(output) <FocusIn> "$itk_component(input) takeFocus"


	# buttons area
 	itk_component add   butframe  { TButtonArea [childsite buttons].bf } {keep -background}
	pack $itk_component(butframe) -expand true -fill both -ipadx 0 -ipady 0 -padx 0 -pady 0
	
	eval itk_initialize $args

	fraction 10 90
	set CBMFractions [getFractions]

	global _TMudderUif
	set _TMudderUif($this,CButtonsShow) 1
    }
    method adjustHLines { aOutX aTabL aCHis} {
	$itk_component(input)  resizeHist $aCHis
	$itk_component(output) resizeHist $aOutX $aTabL 
    }
    method showButtons {} {
	global _TMudderUif
	set _TMudderUif($this,CButtonsShow) 1
	show buttons
	eval fraction $CBMFractions
    }
    method hideButtons {} {
	global _TMudderUif
	set _TMudderUif($this,CButtonsShow) 0
	set CBMFractions [getFractions]
	hide buttons
    }
    method getLayout {} {
	global _TMudderUif
	set retval [list]
	if {$_TMudderUif($this,CButtonsShow)} { set CBMFractions [getFractions] }
	lappend retval $_TMudderUif($this,CButtonsShow)
	lappend retval $CBMFractions
	return $retval
    }
    method setLayout {aLayout} {
	global _TMudderUif	
	set _TMudderUif($this,CButtonsShow) [lindex $aLayout 0]
	set CBMFractions                    [lindex $aLayout 1]
	if {$_TMudderUif($this,CButtonsShow)} { 
	    show buttons
	    eval fraction $CBMFractions
	} else {
	    hide buttons	    
	}
    }
    method getGlobalVar {} { return _TMudderUif }
    method getShowButtonsVar {} { return _TMudderUif($this,CButtonsShow) }
    method getShowButtons {} { global _TMudderUif ; return $_TMudderUif($this,CButtonsShow) }
    method takeFocus {} { $itk_component(input) takeFocus ; }
    method getEntryX {} { return $itk_component(input) } 
    method getOutput {} { return $itk_component(output) }
    method getButtonArea {} { return $itk_component(butframe) }
    method bindToSes {aSes} {
	$itk_component(input) bindToSes $aSes
	after 5000 "$itk_component(input) takeFocus"
    }

}


# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TMudder.tcl,v $
# Revision 1.2  2001/08/19 12:25:42  issever
# Added the cvs keywords Id at start of the file
# and Log at the end of the file
#
#
