# $Id: TOutX.tcl,v 1.4 2002/04/27 20:58:57 issever Exp $

class TOutX {
    inherit iwidgets::Scrolledtext

    variable CBlink
    variable CTabLines
    variable CMaxLines
    variable CMaxDelLines

    variable CActFG
    variable CActBG
    variable CActBL
    variable CActFN
    variable CActINV
    variable COldFG
    variable COldBG
    variable COldBL
    variable COldFN
    variable COldINV

    variable CVLines
    variable CVColumns
    variable CRemCursorLine
    variable CRemCursorColumn

    variable CScrollRegionStart
    variable CScrollRegionEnd
    variable CScrollRegion

    variable CScrollLevels

#     variable CTopWid
#     variable CBotWid

    variable CColM

    #constructor {aTopWid aBotWid args} 
    constructor {aColM args} {
	#set CTopWid $aTopWid
	#set CBotWid $aBotWid

	set CColM $aColM

	bind $itk_interior <Configure> [code $this reconfiguration]
	set CVLines   0
	set CVColumns 0
	set CRemCursorLine   1
	set CRemCursorColumn 0

	set CScrollRegionStart 1
	set CScrollRegionEnd   1
	set CScrollRegion      0

	set CScrollLevels(lock)       1
	set CScrollLevels(evaluation) 1
	set CScrollLevels(input)      1
	set CScrollLevels(readasmud)  1
	set CScrollLevels(showme)     0
	set CScrollLevels(line)       1
	set CScrollLevels(packet)     1

	set CBlink    0
	set CTabLines 50
	set CMaxLines 500
	set CMaxDelLines [expr int(1.1 * $CMaxLines)]

	set CActFG  FGdef
	set CActBG  BGdef
	set CActBL  BLOff
	set CActFN  FNdef 
	set CActINV 0
	set COldFG  FGdef
	set COldBG  BGdef
	set COldBL  BLOff
	set COldFN  FNdef 
	set COldINV 0
	
	foreach ttt [list BG FG] {
	    foreach col [list def black red green yellow blue red2 blue2 white] {
		switch $col {
		    def     { set colorname "TColor::$ttt\Mud"} 
		    default { set colorname "TColor::$ttt$col" }
		}
		eval set colorvalue $$colorname
		switch $ttt {
		    BG {
			tag configure BG$col -background $colorvalue
			$CColM add "BG $col" BG$col $colorvalue 0
			$CColM addCommand    BG$col [code $this tag configure BG$col -background %c] 
		    }
		    FG {
			tag configure FG$col -foreground $colorvalue
			$CColM add "FG $col" FG$col $colorvalue 1
			$CColM addCommand    FG$col [code $this tag configure FG$col -foreground %c] 
		    }
		}
	    }
	}
	#tag configure FGdef    -foreground $TColor::FGMud
	# 	tag configure BGdef    -background $TColor::BGMud
# 	tag configure FGblack  -foreground $TColor::FGblack
# 	tag configure FGred    -foreground $TColor::FGred
# 	tag configure FGgreen  -foreground $TColor::FGgreen
# 	tag configure FGyellow -foreground $TColor::FGyellow
# 	tag configure FGblue   -foreground $TColor::FGblue
# 	tag configure FGred2   -foreground $TColor::FGred2
# 	tag configure FGblue2  -foreground $TColor::FGblue2
# 	tag configure FGwhite  -foreground $TColor::FGwhite
# 	tag configure BGblack  -background $TColor::BGblack
# 	tag configure BGred    -background $TColor::BGred
# 	tag configure BGgreen  -background $TColor::BGgreen
# 	tag configure BGyellow -background $TColor::BGyellow
# 	tag configure BGblue   -background $TColor::BGblue
# 	tag configure BGred2   -background $TColor::BGred2
# 	tag configure BGblue2  -background $TColor::BGblue2
# 	tag configure BGwhite  -background $TColor::BGwhite
	tag configure FNdef    -font mudDef
	tag configure FNbold   -font mudBold
	tag configure BLon     -foreground $TColor::BGMud -background $TColor::FGMud	
	$CColM addCommand FGdef [code $this tag configure BLon -background %c] 
	$CColM addCommand BGdef [code $this tag configure BLon -foreground %c] 


	configure -visibleitems 80x49
	configure -setgrid true
	configure -spacing1 0
	configure -spacing2 0
	configure -spacing3 0
	configure -wrap word
	configure -textfont mudDef
	configure -textbackground $TColor::BGMud
	configure -foreground $TColor::FGMud
	$CColM addCommand FGdef [code $this configure -foreground %c] 
	$CColM addCommand BGdef [code $this configure -textbackground %c] 
	
	
	tag configure input    \
	    -background $TColor::BGMudIn \
	    -foreground $TColor::FGMudIn \
	    -font mudDef
	$CColM add "BG input def" BGMudIn $TColor::BGMudIn 2
	$CColM addCommand         BGMudIn [code $this tag configure input -background %c]
	$CColM add "FG input def" FGMudIn $TColor::FGMudIn 2
	$CColM addCommand         FGMudIn [code $this tag configure input -foreground %c]
	tag configure inputNL    \
	    -background $TColor::BGMud \
	    -foreground $TColor::FGblue \
	    -font mudDef
	$CColM add "BG input newline" BGMudInNL $TColor::BGMud 2
	$CColM addCommand             BGMudInNL [code $this tag configure inputNL -background %c]
	$CColM add "FG input newline" FGMudInNL $TColor::FGblue 2
	$CColM addCommand             FGMudInNL [code $this tag configure inputNL -foreground %c]
	tag configure inputimportant  \
	    -background $TColor::BGMudInImportant \
	    -foreground $TColor::FGMudInImportant \
	    -font mudDef
	$CColM add "BG input important" BGMudInImportant $TColor::BGMudInImportant 2
	$CColM addCommand         BGMudInImportant [code $this tag configure inputimportant -background %c]
	$CColM add "FG input important" FGMudInImportant $TColor::FGMudInImportant 2
	$CColM addCommand         FGMudInImportant [code $this tag configure inputimportant -foreground %c]




# 	itk_component add top {
# 	    iwidgets::scrolledtext $CTopWid.t \
# 		-setgrid true \
# 		-spacing1 0 \
# 		-spacing2 0 \
# 		-spacing3 0 \
# 		-textfont mudDef \
# 		-textbackground $TColor::BGMud \
# 		-foreground $TColor::FGMud \
# 		-wrap word \
# 		-hscrollmode none \
# 		-vscrollmode static 
# 	} { keep -background }
# 	itk_component add bot {
# 	    iwidgets::scrolledtext $CBotWid.t \
# 		-setgrid true \
# 		-spacing1 0 \
# 		-spacing2 0 \
# 		-spacing3 0 \
# 		-textfont mudDef \
# 		-textbackground $TColor::BGMud \
# 		-foreground $TColor::FGMud \
# 		-wrap word \
# 		-hscrollmode none \
# 		-vscrollmode static 
# 	} { keep -background }

	eval itk_initialize $args
	after 15000 [code $this startBlinking]
    }

    method reconfiguration {}       ;# keeps trach of number of visible lines and cols
    method startBlinking {}         ;# keeps the blinking taged text blinking
    method resizeHist {aOutX aTabL} ;# resizes tabhistory and screen history
    method getTabs {}               ;# gets the list of tab completition words in the window
    method setColors {nr}           ;# handles the ESC[#;#;#...m sequence
    method clearOutdatedLines {}    ;# removes text lines, if history becomes to long
    method clear              {} { 
	#puts "clear"
	delete 1.0 end 
    }
    method clearToStart       {} { 
	#puts "clear start"
	delete 1.0 insert }
    method clearToEnd         {} { 
	#puts "clear end"
	delete insert end }
    method clearToEndOfLine   {} { 
	#puts "clear end line"
	delete insert {insert lineend} }
    method clearToStartOfLine {} { 
	delete {insert linestart} insert }
    method getLastLine {} {
	return [get $_mil "$_mil lineend"] 
    }

    #
    # last line modifiers
    #
    method deleteLastLine {} {
	delete $_mil "$_mil lineend + 1 c"
    }
    method deleteRangeOnLastLine {start end} {
	delete "$_mil + $start c" "$_mil + $end c"
    }
    method replaceLastLine {text} {
	set tt [tag names $_mil]
	delete $_mil "$_mil lineend"
	insert $_mil $text $tt
    }
    method replaceOnLastLine {start end text} {
	set si [index "$_mil + $start c"]
	set tt [tag names $si]
	delete $si "$_mil + $end c"
	insert $si $text $tt
    }
    method tagLastLine {tags} {
	set taggers [tag names $_mil]
	foreach tt $tags {
	    set index [lsearch -glob $taggers "[string range $tt 0 1]*"]
	    if {$index != -1 } {
		tag remove [lindex $taggers $index] $_mil "$_mil lineend"
	    }
	    tag add $tt $_mil "$_mil lineend"
	}
    }
    method tagOnLastLine {start end tags} {
	set si "$_mil + $start c"
	set ei "$_mil + $end c"
	set taggers [tag names $si]
	foreach tt $tags {
	    set index [lsearch -glob $taggers "[string range $tt 0 1]*"]
	    if {$index != -1 } {
		tag remove [lindex $taggers $index] $si $ei
	    }
	    tag add $tt $si $ei
	}
    }
    method tagNreplaceLastLine {text tags} {
	delete $_mil "$_mil lineend"
	insert $_mil  $text $tags
    }
    method tagNreplaceOnLastLine {start end text tags} {
	delete "$_mil + $start chars" "$_mil + $end c"
	insert "$_mil + $start chars" $text $tags
    }



    private variable _mil 1.0
    method fromMud {aStr} {
	insert end "$aStr" "$CActFG $CActBG $CActFN $CActBL"
	set _mil [index {end - 1 c linestart}]
	#if {$CScrollRegion} {
	#    set l [regsub -all -- "\n" $aStr {} d]
	#    puts "delete $CScrollRegionStart.0 [expr $CScrollRegionStart+$l].0"
	#    delete $CScrollRegion.0 [expr $CScrollRegion+$l].0
	#}
	seeEnd evaluation
    }
    method fromSMM {aStr} {
	insert end "$aStr" "input"
	endl
    }
    method userPrint {aStr aTagList} {
	insert end $aStr $aTagList
	seeEnd showme
    }
    method fromSMMImportant {aStr} {
	insert end "$aStr" "inputimportant"
	endl
    }
    method fromInput {aStr} {
	if {[string compare "" $aStr]} {
	    insert end "$aStr" "input"
	} else {
	    insert end "<Return>" "inputNL"
	}
	endl
    }
    method endl {} {
	insert end "\n" "FGdef BGdef FNdef"
	clearOutdatedLines
	seeEnd input
    }
    method moveCursorTo {arg} {
	set line 1
	set col  0
	regexp -- {([0-9]+);([0-9]+)} $arg dummy line col
	#puts "moveto: '$line'-'$col'"

	::scan [index end]    "%u.%u" endline endcol	
	if {$endline>$CVLines} {
	    set line [expr $endline-$CVLines+$line]
	} 
	createLineIfNeeded $line
	setInsert $line $col
    }


    method getTextSelection {} {
      return [get sel.first sel.last]
    }

    method setScrollRegion {arg} {
	regexp -- {([0-9]+);([0-9]+)} $arg dummy CScrollRegionStart CScrollRegionEnd
	
	#$itk_component(top) configure -visibleitems 80x$CScrollRegionStart
	#set l [max 1 [expr $CVLines-$CScrollRegionEnd]]
	#puts ==-------->$l
	#$itk_component(bot) configure -visibleitems 80x$l
	#pack $itk_component(top) -side top -fill x -expand false 
	#pack $itk_component(bot) -side top -fill x -expand false 
	#set CScrollRegion 1

	#puts "SET SR: $CScrollRegionStart $CScrollRegionEnd"
    }

    method setScrollLevel {which level} {
	if {[ expr $level >= 0 ]} {
	    set CScrollLevels($which) $level
	    return $level
	}
    }
    method getScrollLevel {which} {
	return $CScrollLevels($which)
    }
    method seeEnd {caller} {
	if { [expr $CScrollLevels($caller) >= $CScrollLevels(lock)] } {
	    see end
	}
    }

    method rememberCursorPosition {} { 
	#puts "rem pos"
	::scan [index insert] "%u.%u" curline CRemCursorColumn
	::scan [index end]    "%u.%u" endline endcol	
	set CRemCursorLine [expr $CVLines-$endline+$curline]
    }
    method returnToCursorPosition {} { 
	#puts "set pos"
	::scan [index end]    "%u.%u" endline endcol	
	set l [expr $endline-$CVLines+$CRemCursorLine]
	createLineIfNeeded $l
	setInsert $l $curcol
    }
    method setInsert {aLine aColumn} {
	# the line must exist already
	::scan [index $aLine.end]  "%u.%u" line maxcol
	set app [expr $aColumn-$maxcol]
	if {$app>0} {
	    set str ""
	    for {set i 0} {$i<$app} {incr i} {append str " "}
	    insert $line.end $str
	    mark set insert $line.end
	} else {
	    mark set insert $line.[expr $aColumn]
	}
    }
    method createLineIfNeeded {aLine} {
	::scan [index end] "%u.%u" maxline col
	if {$aLine>$maxline} {
	    set app [expr $aLine - $maxline]
	    set str ""
	    for {set i 0} {$i<$app} {incr i} {append str "\n"}
	    set curpos [index insert]
	    insert end $str
	    #puts "$app/$aLine/$maxline{$str}"
	    mark set insert $curpos
	}
    }
    method movedown {a} {
	#puts "move down: $a"
	::scan [index insert] "%u.%u" curline curcol
	set l [expr $curline+$a]
	createLineIfNeeded $l
	setInsert $l $curcol
    }
    method delChars {a} {
	#puts "del chars: $a"
	delete insert "insert + $a chars"
    }
    method addLinesBeforeCurPos {a} {
	#puts "add lines: $a"
	set str ""
	for {set i 0} {$i<$a} {incr i} {append str "\n"}
	set curpos [index insert]
	insert {insert linestart} $str
	mark set insert $curpos
    }
    method remLinesAfterCurPos {a} {
	#puts "rem lines: $a"
	::scan [index insert] "%u.%u" curline curcol

	set l [expr $curline+$a]
	createLineIfNeeded $l
	incr l
	for {set i [expr $a+1]} {$i<$l} {incr i} {
	    delete "$a.0" "$a.end"
	}
	
	mark set insert $curline.$curpos
    }
    method moveup {a} {
	return
	#puts "move up: $a"
	::scan [index insert] "%u.%u" curline curcol
	set l [max [expr $curline-$a] 1]
	setInsert $l $curcol
    }
    method moveleft {a} {
	#puts "move left: $a"
	::scan [index insert] "%u.%u" curline curcol
	mark set insert "$curline.[max [expr $curcol-$a] 0]"
    }
    method moveright {a} {
	#puts "move right: $a"
	::scan [index  insert]           "%u.%u" curline curcol
	setInsert $curline [expr $curcol+$a]
    }
}
####################################################################################
body TOutX::reconfiguration {} {
    regexp -- {([0-9]+)x([0-9]+)} [cget -visibleitems] dummy CVColumns CVLines
}
body TOutX::resizeHist {aOutX aTabL} {
    set CTabLines $aTabL
    set CMaxLines $aOutX
    set CMaxDelLines [expr int(1.1 * $CMaxLines)]
}
body TOutX::startBlinking {} {
    if {$CBlink} {
	set CBlink 0
	tag lower BLon
    } else {
	set CBlink 1
	tag raise BLon
    }
    after 1000 [code $this startBlinking]
}
body TOutX::clearOutdatedLines {} {
    ::scan [index end] "%u" numlines
    if {$numlines > $CMaxDelLines} {
	set  b [expr $numlines - $CMaxLines ]
	delete 1.0 "$b.0"
    }
}
body TOutX::getTabs {} {
    set listi [list]
    set text [get "end linestart - $CTabLines lines" end]
    regsub -all {\[} $text {\\\[} text
    regsub -all {\]} $text {\\\]} text
    foreach word [split $text] {
	lappend listi $word
    }
    return $listi
}
body TOutX::setColors {nr} {
    foreach n [split $nr \;] {
	switch -exact -- $n {
	    0 {
		set COldFG     $CActFG   
		set COldBG     $CActBG  
		set COldFN     $CActFN  
		set COldBL     $CActBL
		set COldINV    $CActINV

		set CActFG     FGdef
		set CActBG     BGdef
		set CActFN     FNdef
		set CActBL     BLoff
		set CActINV 1
	    }
	    1 {
		set CActFN     FNbold
	    }
	    5 {
		set CActBL     BLon
	    }
	    7 {
		msgError "INVERT ON!"
		if {$CActINV} {
		    set helpi      $CActFG     
		    set CActFG     $CActBG
		    set CActBG     $helpi
		    set CActINV    0
		}
	    }
	    8  {msgError "SECRET!!"}
	    30 {set CActFG FGblack}
	    31 {set CActFG FGred}
	    32 {set CActFG FGgreen}
	    33 {set CActFG FGyellow}
	    34 {set CActFG FGblue}
	    35 {set CActFG FGred2}
	    36 {set CActFG FGblue2}
	    37 {set CActFG FGwhite}
	    40 {set CActBG BGblack}
	    41 {set CActBG BGred}
	    42 {set CActBG BGgreen}
	    43 {set CActBG BGyellow}
	    44 {set CActBG BGblue}
	    45 {set CActBG BGred2}
	    46 {set CActBG BGblue2}
	    47 {set CActBG BGwhite}
	    100 {
		set CActFG            $COldFG   
		set CActBG            $COldBG  
		set CActFN            $COldFN  
		set CActBL            $COldBL
		set CActINV           $COldINV
	    }
	    default {
		#msgError "ESC nr m seq -> $n <$nr>"
	    }
	}
    }
}




# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TOutX.tcl,v $
# Revision 1.4  2002/04/27 20:58:57  issever
# again changed some gui colors and
# implmented Hamlets getselection
#
# Revision 1.3  2002/04/22 19:36:06  issever
# implemented Hamlets scroll lock
#
# Revision 1.2  2001/08/19 12:25:42  issever
# Added the cvs keywords Id at start of the file
# and Log at the end of the file
#
#
