# $Id: TTabManager.tcl,v 1.2 2001/08/19 12:25:42 issever Exp $

class TTabManager {
    variable CList

    constructor {} {
	set CList [list]
    }
    destructor { 
	clear 
    }
    method exists {aName} { 
	if {[lsearch -exact $CList $aName]==-1} { return 0 } else { return 1 }
    }
    method rem {aName} { 
	set pos [lsearch -exact $CList $aName]
	if {$pos!=-1} { 
	    set CList [lreplace $CList $pos $pos] 
	}
    }
    method add {aName} { 
	if {![exists $aName]} {
	    lappend CList $aName
	}
    }
    method getAllNames {} { 
	return $CList
    }
    method clear {} { 
	set CList [list]
    }

    method getTabs {} {
	return $CList
    }

}


# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TTabManager.tcl,v $
# Revision 1.2  2001/08/19 12:25:42  issever
# Added the cvs keywords Id at start of the file
# and Log at the end of the file
#
#
