# $Id: TTicker.tcl,v 1.3 2002/04/28 13:43:35 issever Exp $

class TTicker {

    variable CTickSize
    variable CTickCounter

    variable CSes
	
    variable CCommandArray
    
    method bindToSes {aSes} {
	set CSes    $aSes
    }
    method unbindFromSes {} {
	set CSes    ""
	stop
	clear
	set CTickSize     75
    }

    method isBoundToSes {} {
	return [string compare "" $CSes]
    }
    method stop {} { 
	global __Ticker
	after cancel [code $this ticking] 
	set CTickCounter  0	
	updateLabel
	set __Ticker($this,indicator) 0
    }
    method start {} { 
	global __Ticker

	if {[isBoundToSes]} {
	    ticking 
	    set __Ticker($this,indicator) 1
	} else {
	    stop
	}
    }
    method reset {} {
	set CTickCounter 0
    }
    method setSize {aSize} {
	set CTickSize    [expr {$aSize - 1}]
	set CTickCounter 0
	updateLabel
    }
    method getTick {} {
	return $CTickCounter
    }
    method setTick {aCount} {
	if {$aCount < 0} {
	    set aCount 0	    
	}
	set CTickCounter $aCount
	updateLabel	
    }

    method addTickCommand {aSec aCom} {
	set CCommandArray([expr $aSec]) $aCom
    }
    method remTickCommand {aSec} {
	if {[info exists CCommandArray([expr $aSec])]} {
	    unset CCommandArray([expr $aSec])
	}
    }
    method clear {} {
	foreach index [array names CCommandArray] {
	    unset CCommandArray($index)
	}
    }
    method getAllTimes {} { return [lsort -integer [array names CCommandArray]] }
    method getCommand {aSec} {
	if {[info exists CCommandArray([expr $aSec])]} {
	    return "$CCommandArray([expr $aSec])"
	} else {
	    return ""
	}
    }
    method existsCommand {aSec} {
	return [info exists CCommandArray([expr $aSec])]
    }


    method toggle {} {
	global __Ticker
	if {$__Ticker($this,indicator)} {
	    start
	} else {
	    stop
	}
    }

    method getLabelVarName {} { return "__Ticker($this,label)" }
    method getIndicatorVarName {} { return "__Ticker($this,indicator)" }
    method updateLabel {} {
	global __Ticker
	set __Ticker($this,label) "Tick \[[format {%4d} $CTickCounter]/[format {%4d} $CTickSize]\]"
    }
    constructor {} {
	global __Ticker

	set CTickSize     75
	set CTickCounter  0	
	updateLabel	

	set __Ticker($this,indicator) 0

	set CSes    ""
    }

    method ticking {} {
	after 1000 [code $this ticking]

	incr CTickCounter -1
	if { $CTickCounter < 0 } { set CTickCounter $CTickSize }	
	updateLabel

	if {[info exists CCommandArray($CTickCounter)]} {
	    $CSes toSMM $CCommandArray($CTickCounter)
	}
    }
}



# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TTicker.tcl,v $
# Revision 1.3  2002/04/28 13:43:35  issever
# implemented Hamlets ticker overhaul.
# Important: setting tickersize has changed.
# set size x, sets the maxcount to x-1. before it
# was set to x and the loop took x+1 seconds.
#
# Revision 1.2  2001/08/19 12:25:42  issever
# Added the cvs keywords Id at start of the file
# and Log at the end of the file
#
#
