# $Id: TCN.tcl,v 1.2 2001/08/19 12:25:42 issever Exp $

#=======================================================
# a TCNObject is a object with a type, class and a name
class TCNObject {
    public {
	constructor {aType aCategory aName} {}
	method getName {}
	method getCategory {}
	method getType {}
	method TCNId {}	
	method TCId {}	
	method TId {} 
	method isType {aType}
	method isCategory {aCategory}
	proc   getTCIdCategory {aTCId}
	proc   getTCIdType     {aTCId}
	proc   getTCNId        {aType aCategory aName}
    }
    private {
	variable CName
	variable CCategory
	variable CType
    }   
}

#=======================================================
# this a container designed for TCNObjects
class TCNContainer {
    public {
	constructor            {} {}
	method add             {aTCNObject}
	method getTypes        {}
	method getCategories   {aType}
	method getNames        {aType aCategory}
	method getObjects      {aType aCategory}
	method getObject       {aType aCategory aName}
    }
    private {
	variable CTCNObjectArray
	variable CTypesList
	variable CCategoriesList
	method typeExists      {aTCNObject}
	method categoryExists  {aTCNObject}
	method TCNObjectExists {aTCNObject}
    }
}

########################################################
### CLASS DEFINITIONS
########################################################
#=======================================================
# TCNObject definition
body TCNObject::constructor {aType aCategory aName} {
    set CName     $aName
    set CCategory $aCategory
    set CType     $aType    
}
body TCNObject::getName     {} { return $CName }
body TCNObject::getCategory {} { return $CCategory }
body TCNObject::getType     {} { return $CType }
body TCNObject::TCNId       {} { return [list $CType $CCategory $CName] }
body TCNObject::TCId        {} { return [list $CType $CCategory] }
body TCNObject::TId         {} { return [list $CType] }
body TCNObject::getTCIdType     {aTCId} { return [lindex $aTCId 0] }
body TCNObject::getTCIdCategory {aTCId} { return [lindex $aTCId 1] }
body TCNObject::isType      {aType} {
    if {[string compare $aType $CType] == 0} { return 1 } else { return 0 }
}
body TCNObject::isCategory  {aCategory} {
    if {[string compare $aCategory $CCategory] == 0} { return 1 } else { return 0}
}
body TCNObject::getTCNId {aType aCategory aName} {
    return [list $aType $aCategory $aName]
}
#=======================================================
# TCNContainer definiton
body TCNContainer::getTypes      {} {
    return [lsort $CTypesList]
}
body TCNContainer::getCategories {aType} {
    set l [list]
    foreach tcid $CCategoriesList {
	set type [TCNObject::getTCIdType $tcid]
	if {[string compare $type $aType] == 0} {
	    set cat  [TCNObject::getTCIdCategory $tcid]
	    lappend l $cat
	}
    }
    return [lsort $l]
}
body TCNContainer::getNames      {aType aCategory} {
    set l [list]
    foreach TCNId [array names CTCNObjectArray] {
	set obj $CTCNObjectArray($TCNId) 
	if {[$obj isType $aType] && [$obj isCategory $aCategory]} {
	    lappend l [$obj getName]
	}	
    }
    return [lsort $l]
}
body TCNContainer::getObjects    {aType aCategory} {
    set l  [list]
    set ll [list]
    foreach TCNId [array names CTCNObjectArray] {
	set obj $CTCNObjectArray($TCNId) 
	if {[$obj isType $aType] && [$obj isCategory $aCategory]} {
	    lappend l [$obj getName]
	}	
    }
    foreach name [lsort $l] {
	lappend ll [TCNContainer::getObject $aType $aCategory $name]
    }
    return $ll
}
body TCNContainer::getObject {aType aCategory aName} {
    return $CTCNObjectArray([TCNObject::getTCNId $aType $aCategory $aName])
}
body TCNContainer::constructor {} {
    set CTypesList            [list]
    set CCategoriesList       [list]
}
body TCNContainer::typeExists      {aTCNObject} {
    if {[lsearch -exact $CTypesList [$aTCNObject TId]] == -1} {
	return 0
    } else {
	return 1
    }
}
body TCNContainer::categoryExists  {aTCNObject} {
    if {[lsearch -exact $CCategoriesList [$aTCNObject TCId]] == -1} {
	return 0
    } else {
	return 1
    }
}
body TCNContainer::TCNObjectExists {aTCNObject} {
    return [info exists CTCNObjectArray([$aTCNObject TCNId])]
}
body TCNContainer::add {aTCNObject} {
    if {![TCNContainer::typeExists     $aTCNObject]} {
	lappend CTypesList      [$aTCNObject TId]
    }
    if {![TCNContainer::categoryExists $aTCNObject]} {
	lappend CCategoriesList [$aTCNObject TCId]
    }
    if {[TCNContainer::TCNObjectExists $aTCNObject]} {
	error "Such TCN-Object already exists in this container!"
    } else {
	set CTCNObjectArray([$aTCNObject TCNId]) $aTCNObject
    }
}
#=======================================================
#=======================================================




# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TCN.tcl,v $
# Revision 1.2  2001/08/19 12:25:42  issever
# Added the cvs keywords Id at start of the file
# and Log at the end of the file
#
#
