# $Id: TColor.tcl,v 1.5 2002/04/27 19:26:56 issever Exp $

class TColor {
    common BGlight "\#ffffff"
    common BGdef   "\#daceaf"
    common BGdark  "\#a59575"

    # daceaf -> 218 206 175

    common BGWinBorder "\#f7e78e"

    common BGInsertCursor "\#de8"

    common FGdef   "\#000000"


    common BGMud             \#000000
    common FGMud             \#aaaaaa
    common BGMudIn           \#998888
    common FGMudIn           \#ccccff
    common BGMudInImportant  \#998888
    common FGMudInImportant  \#FF8866
    common BGCom             \#daceaf
    common FGCom             \#000000
    
    common FGblack   \#333333
    common FGred     red
    common FGgreen   green
    common FGyellow  yellow
    common FGblue    RoyalBlue1
    common FGred2    red4
    common FGblue2   cyan
    common FGwhite   white
    common BGblack   black
    common BGred     red
    common BGgreen   green
    common BGyellow  yellow
    common BGblue    RoyalBlue1
    common BGred2    red4
    common BGblue2   cyan
    common BGwhite   white

    
    # scriptfile editor
    common SCcursor     \#ff5555
    common SCBGdef      \#ffffff
    common SCFGdef      \#000000
    common SCFGcomment  \#ff0000
    common SCFGstring   \#00ff00
    common SCFGcommand  \#0000ff
    common SCFGvariable \#ffff00
    common SCFGspecial  \#ffa600






    proc smmToTk {aC} {
	switch $aC {
	    "bg def" {return $BGdef} 
	    "bg dark" {return $BGdark}
	    default { return $aC }
	}
    }

    constructor {} {
	global tcl_platform

	switch -regexp -- $tcl_platform(platform) {
	    win.*    {_optionsWin}
	    default  {_optionsMisc}
	}
    }
    
    private {
	method _optionsWin {} {
	    option add *background             $BGdef     startupFile
	    option add *Background             $BGdef     startupFile
	    option add *foreground             $FGdef     startupFile
	    #option add *selectColor            \#ff8888   startupFile
	    option add *Checkbutton*Background white     startupFile
	    option add *Radiobutton*Background white     startupFile
	    option add *textBackground         $BGlight   startupFile
	    option add *selectBackground       $BGdark    startupFile
	    option add *highlightColor         \#666666   startupFile
	    option add *activeBackground       \#b8ac8d   startupFile
	    option add *activeForeground       \#444444   startupFile
	    option add *selectForeground       \#ccccee   startupFile
	    option add *troughColor            \#eeddcc   startupFile
	    option add *disabledForeground     \#888888   startupFile
	    
	    option add *TSessionUif*background $BGdef     startupFile
	}
	method _optionsMisc {} {
	    option add *background             $BGdef     startupFile
	    option add *Background             $BGdef     startupFile
	    option add *foreground             $FGdef     startupFile
	    option add *selectColor            \#cc4444   startupFile
	    option add *textBackground         $BGlight   startupFile
	    option add *selectBackground       $BGdark    startupFile
	    option add *highlightColor         \#666666   startupFile
	    option add *activeBackground       \#b8ac8d   startupFile
	    option add *activeForeground       \#444444   startupFile
	    option add *selectForeground       \#ccccee   startupFile
	    option add *troughColor            \#eeddcc   startupFile
	    option add *disabledForeground     \#888888   startupFile
	    
	    option add *TSessionUif*background $BGdef     startupFile
	    
	}
    }
}





# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TColor.tcl,v $
# Revision 1.5  2002/04/27 19:26:56  issever
# adjusted linux GUI colors
#
# Revision 1.4  2002/04/20 16:31:51  issever
# adjusted colors for windows
#
# Revision 1.3  2002/04/16 21:53:32  issever
# changed default select color
#
# Revision 1.2  2001/08/19 12:25:42  issever
# Added the cvs keywords Id at start of the file
# and Log at the end of the file
#
#
