# $Id: TESCParser.tcl,v 1.2 2001/08/19 12:25:42 issever Exp $

class TESCParser {
    # leading 'esc' must be stripped already!
    variable CESCIntermediates
    variable CESCParameters
    variable CESCFinal
    variable CESCDummy
    variable CESCParsedText    

    constructor {} {
	set CESCIntermediates  ""
	set CESCParameters     ""
	set CESCFinal          ""
	set CESCDummy          ""
	set CESCParsedText     ""
    }    
    method escAnalyse {aStr} {
	if {[ regexp -- {^\[([0-?]*)([ -/]*)([@-~])(.*)} \
		  $aStr CESCDummy CESCParameters CESCIntermediates CESCFinal CESCParsedText]} {
	    return 1
	}
	if {[ regexp -- {^([ -/]*)([0-~])(.*)} \
		 $aStr CESCDummy CESCIntermediates CESCFinal CESCParsedText]} {
	    set CESCParameters     ""
	    return 1
	}
	set CESCIntermediates  ""
	set CESCParameters     ""
	set CESCFinal          ""
	set CESCParsedText     $aStr
	return 0
    }
    method escCode {}       { return $CESCFinal }
    method escRestOfText {} { return $CESCParsedText}
    method escArg {}        { return $CESCParameters }

}





# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TESCParser.tcl,v $
# Revision 1.2  2001/08/19 12:25:42  issever
# Added the cvs keywords Id at start of the file
# and Log at the end of the file
#
#
