# $Id: TFileSystemManager.tcl,v 1.3 2001/12/08 18:53:35 issever Exp $

class TFileSystemManager {
    private variable CPath ;# this is the path to the user dir
    private variable CRPMD ;# rel path to muds dir
    private variable CRPSD ;# rel path to sess dir

    private variable CFSVersion
    private variable CSrcPath

    constructor {aPath aSrcPath} {
	set CFSVersion "2"
	set CPath $aPath
	set CRPMD "muds" 
	set CRPSD "sessions"
	
	set CSrcPath $aSrcPath

	if {![smmIsInstalled]} {
	    installSmm
	} else {
	    # test filesys version
	    switch -- [getUserDirFSVersion] {
		1 {
		    file mkdir  [getScriptDir]
		    writeSMMDat
		}
		2 {
		    writeSMMDat
		}
		default {
		    error "Unknown fileSystem version!"
		    exit
		}
	    }
	}
    }
    method smmIsInstalled {} {
	return [file exists $CPath]
    }
    method installSmm {} {	
	# this method is only called, if user filesystem is not existing yet.
	# create user directories
	file mkdir  [getUserDir]
	file mkdir  [getMudParentDir]
	file mkdir  [getSesParentDir]
	file mkdir  [getScriptDir]
	
	writeSMMDat
    }
    private {
	method getUserDirFSVersion {} {
	    set fid [open [getSMMDat] "r"]
	    gets $fid smmv
	    gets $fid fsv
	    close $fid
	    regexp {Filesystem version: ([0-9]+)} $fsv dummy retval
	    return $retval
	}
	method writeSMMDat {} {
	    # Writes a new smm.dat. Deletes an existing.
	    global SMM
	    set fid [open [getSMMDat] "w+"]
	    puts $fid "SMM version:        $SMM(version)"
	    puts $fid "Filesystem version: $CFSVersion" 
	    close $fid
	}
    }
    ###=== SYS --------------
    method getSysDir          {}    { return $CSrcPath }       
    method getSysDirImages    {}    { return [file join [getSysDir] images]} 
    method getSysDirConfig    {}    { return [file join [getSysDir] config] }
    #----- CONFIG FILES -----
    method getSysDirScripts     {}          { return [file join [getSysDirConfig] scripts] }
    method getSysScriptWelcome  {}          { return [file join [getSysDirScripts] welcome] }
    method getSysScriptFile     {aFileName} { return [file join [getSysDirScripts] $aFileName] }
    method getSysAllScriptFiles {}          {
	return [lsort [glob -nocomplain -- [file join [getSysDirScripts] *]]]}
    method getSysAllScriptFileNames {}      {
	set retval [list]
	foreach fn [getSysAllScriptFiles] {
	    lappend retval [file tail $fn]
	}
	return $retval
    }
    method getSysDirNamecreator {} { return [file join [getSysDirConfig] namecreator] }
    method getSysNameDB         {} { return [file join [getSysDirNamecreator] namedb] }
    

    ###=== USER -------------
    #----- SCRIPTS ----------
    method getScriptDir       {}         { return [file join [getUserDir] scripts] }
    method getScriptFile      {aName}    { return [file join [getScriptDir] $aName] }
    method getAllScriptFiles  {}    { 
	return [lsort [glob -nocomplain -- [file join [getScriptDir] *]]]}
    method getAllScriptFileNames {}      {
	set retval [list]
	foreach fn [getAllScriptFiles] {
	    lappend retval [file tail $fn]
	}
	return $retval
    }

    #----- MISC -------------
    method getUserDir         {}    { return $CPath }
    method getSMMDat          {}    { return [file join [getUserDir] smm.dat] }
    method getColorrc         {}    { return [file join [getUserDir] colorrc] }
    method getFontrc          {}    { return [file join [getUserDir] fontrc] }
    method getMouserc         {}    { return [file join [getUserDir] mouserc] }
    method getHLinesFile      {}    { return [file join [getUserDir] hlines] }
    method getLayoutFile      {aId} { 
	switch -- $aId {
	    sepMapWin {
		return [file join [getUserDir] smw.layout] 
	    }
	    default {
		return [file join [getUserDir] def.layout] 
	    }
	}
    }
    #----- MUD --------------
    method getMudParentDir    {}              { return [file join [getUserDir] $CRPMD] }
    method getMudDir          {aMudId}        { return [file join [getMudParentDir] m$aMudId] }
    method getMudMapDir       {aMudId}        { return [file join [getMudDir    $aMudId] maps] }
    method getMudDataFile     {aMudId}        { return [file join [getMudDir    $aMudId] mud.dat] }
    method getMapFile         {aMudId aMapId} { return [file join [getMudMapDir $aMudId] map$aMapId] }

    method getAllMudDataFiles {}              { 
	return [glob -nocomplain -- [file join [getMudParentDir] m* mud.dat]] }
    method getAllMapFiles     {aMudId}        { 
	return [glob -nocomplain -- [file join [getMudMapDir $aMudId] map*] ] }
    #---- SESSION -----------
    method getSesParentDir    {}              { return [file join [getUserDir] $CRPSD] }
    method getSesDir          {aSesId}        { return [file join [getSesParentDir] s$aSesId] }
    method getSesDataFile     {aSesId}        { return [file join [getSesDir $aSesId] ses.dat] }
    method getMainSesConfFile {aSesId}        { return [file join [getSesDir $aSesId] mainconf.dat] }

    method getAllSesDataFiles {}              { 
	return [glob -nocomplain -- [file join [getSesParentDir] s* ses.dat]] }

}


# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TFileSystemManager.tcl,v $
# Revision 1.3  2001/12/08 18:53:35  issever
# Added and edited files for the namecreator.
#
# Revision 1.2  2001/08/19 12:25:42  issever
# Added the cvs keywords Id at start of the file
# and Log at the end of the file
#
#
