# $Id: TFont.tcl,v 1.2 2001/08/19 12:25:42 issever Exp $

# === this is the one used for the maps font, in the roomUif  ===============================
class TFontUif {
    inherit itk::Widget

    constructor {args} {
	global TV
	# family
	itk_component   add family {
	    iwidgets::combobox $itk_interior.family \
		-labeltext "Font:" -labelpos w -width 10 \
		-popupcursor hand1 -listheight 100  \
		-editable 0 -textvariable TV($this,family) 
	} {keep -background}
	# slant
	itk_component   add slant {
	    iwidgets::combobox $itk_interior.slant \
		-labeltext "Slant:" -labelpos w -width 10 \
		-popupcursor hand1 -listheight 100  \
		-editable 0 -textvariable TV($this,slant) 
	} {keep -background}
	#size
	itk_component   add size { 
	    iwidgets::spinint $itk_interior.size \
		-labeltext "Size:" -range {0 64} -width 3 -arroworient horizontal
	} {keep -background}
	pack $itk_component(family) $itk_component(slant) $itk_component(size) \
	    -fill both -expand 1 -ipadx 0 -ipady 0 -padx 0 -pady 0 -side top

	$itk_component(family) insert list end \
	    Ariel Courier Helvetica Knarly Lucida \
	    Rumpus Symbol Times "Zapf Dingbats"
	$itk_component(slant) insert list end \
	    normal bold italic 

	iwidgets::Labeledwidget::alignlabels $itk_component(family) $itk_component(slant) $itk_component(size)

	eval itk_initialize $args
    }

    method getFont {} {
	global TV
	return [list $TV($this,family) [$itk_component(size) get] $TV($this,slant)]
    }
    method setFont {aFont} {
	global TV
	set TV($this,family) [lindex $aFont 0]
	$itk_component(size) delete 0 end
	$itk_component(size) insert 0 [lindex $aFont 1]
	set TV($this,slant) [lindex $aFont 2]
	return [list $TV($this,family) [$itk_component(size) get] $TV($this,slant)]
    }



}


# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TFont.tcl,v $
# Revision 1.2  2001/08/19 12:25:42  issever
# Added the cvs keywords Id at start of the file
# and Log at the end of the file
#
#
