# $Id: TGUIManager.tcl,v 1.4 2001/12/22 03:22:03 issever Exp $

class TGUI {
    public common grid 32
    
    common CWinNum

    constructor {aFilM args} {
	set _filM $aFilM
	set CWinNum 0

	# options
	option clear
	#option add *tearOff                false  startupFile
	#option add *sbWidth                   10  startupFile
	option add *highlightThickness         0  startupFile
	#option add *Pushbutton*BorderWidth     2  startupFile

	# init Colors and Font separately
	_setupcolors
	_setupFonts
    }
    public {
	method activateFont {aMaster} { 
	    $_fontmanager configure -master $aMaster
	    $_fontmanager configure -tops $aMaster
	    $_fontmanager activate 
	}
	method activateColor {aMaster} { 
	    $_colormanager configure -master $aMaster
	    $_colormanager configure -tops $aMaster
	    $_colormanager activate 
	}
	method getColorManager {} { return $_colormanager }
	method loadColorrc {} {
	    if {[file exists [$_filM getColorrc]]} {
		$_colormanager load
	    }
	}
    }
    method addGUIColors {} {
	addFGCom [code $_colormanager configure -foreground %c] 
	addFGCom [code $_fontmanager configure -foreground %c] 
    }
    private {
	variable _filM
	variable _colormanager
	variable _color
	variable _fontmanager
	method   _setupFonts {} {
	    font create def      -family Courier -size 12
	    font create defBold  -family Courier -size 12 -weight bold

	    option add *font                   def      startupFile
	    option add *textFont               def      startupFile
	    option add *labelFont              defBold  startupFile

	    set _fontmanager [iwidgets::fontmanager  .\#auto -file [$_filM getFontrc] \
				 -dialogborderwidth 3 -dialogrelief sunken \
				 -modality application -foreground black]


	    $_fontmanager add small    "-family Courier -size 10" \
		"Small GUI font: "
	    $_fontmanager add def      "-family Courier -size 12" \
		"Default GUI font: "
	    $_fontmanager add defBold  "-family Courier -size 12 -weight bold" \
		"Bold GUI font: "
	    $_fontmanager add defFixed "-family Courier -size 12"  \
		"Fixed GUI font: " 
	    $_fontmanager add big      "-family Courier -size 14"  \
		"Big GUI font: " 
	    $_fontmanager add bigBold  "-family Courier -size 14 -weight bold" \
		"Big and Bold GUI font: "
	    $_fontmanager add mudDef   "-family Courier -size 12"  \
		"Default font for MUD text: " 
	    $_fontmanager add mudBold  "-family Courier -size 12 -weight bold" \
		"Bold font for MUD text: "
	    $_fontmanager add scDef    "-family Courier -size 12 -weight bold" \
		"Default font for scriptfile editor: " 
	    
	    if {[file exists [$_filM getFontrc]]} {
		$_fontmanager load
	    }
	}
	method   _setupcolors {} { 
	    set _color        [TColor ::\#auto]
	    set _colormanager [iwidgets::colormanager  .\#auto -file [$_filM getColorrc] \
				 -dialogborderwidth 3 -dialogrelief sunken \
				 -modality application -foreground black]
	}
    }
    proc tlname {args} {
	incr CWinNum
	switch [llength $args] {
	    1 { set wid $args }
	    0 { set wid [focus] }
	}
	#regexp -- {^[.][^.]+} $wid topl
	set topl [winfo toplevel $wid]	
	return "$topl\.w$CWinNum"
    }
    proc tlnameX {args} {
	incr CWinNum
	switch [llength $args] {
	    1 { set wid $args }
	    0 { set wid [focus] }
	}
	regexp -- {^(::|)([.][^.]+)} $wid d1 d2 topl
	return "$topl\.w$CWinNum"
    }
}



# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TGUIManager.tcl,v $
# Revision 1.4  2001/12/22 03:22:03  issever
# removed "option" setting for scrollbar width and buttonborder width
#
# Revision 1.3  2001/12/01 12:05:19  issever
# Slight reorganization of code (menubar)
#
# Revision 1.2  2001/08/19 12:25:42  issever
# Added the cvs keywords Id at start of the file
# and Log at the end of the file
#
#
