# $Id: THLinesConfig.tcl,v 1.2 2001/08/19 12:25:42 issever Exp $

class THLinesConfig {
    inherit iwidgets::Texteddialog

    variable CFilM
    variable CMudder

    constructor {aFilM aMudder args} {
	global _THLinesConfig
	configure -foreground black
	addFGCom [code $this configure -foreground %c] 

	configure -title "History Lines"
	configure -modality application
	configure -text  "Please, adjust the number of lines as you wish."
	configure -aspect 333
	buttonconfigure OK     -text "Create" -command "[code $this save]"
	buttonconfigure Cancel -text "Cancel" -command "[code $this canc]"

	set CFilM   $aFilM
	set CMudder $aMudder

	set wid [$this childsite]

	# ------
	set h(outx) "Output History Lines: "
	set h(tabl) "Tab-History Lines: "
	set h(chis) "Command History: "

	foreach aaa [array names h] {
	    itk_component   add $aaa { 
		iwidgets::spinint  $wid.$aaa \
		    -labeltext $h($aaa) \
		    -step 5 -width 5 -validate numeric \
		    -increment [code $this increm $aaa] -decrement [code $this decrem $aaa] \
		    -arroworient horizontal -textvariable _THLinesConfig($this,$aaa)
	    } {
		keep -background
		keep -foreground
	    }

	    pack $itk_component($aaa) -side top -fill both -expand 1
	    set _THLinesConfig($this,$aaa) 1
	}

	iwidgets::Labeledwidget::alignlabels \
	    $itk_component(outx) $itk_component(tabl) $itk_component(chis) 

	loadHLines

	eval itk_initialize $args	
    }

    method loadHLines {} {
	global _THLinesConfig
	
	set f [$CFilM getHLinesFile]	
	if {[file exists $f]} {
	    set fid [open $f "r"]
	    gets $fid version

	    switch $version {
		1 {
		    gets $fid _THLinesConfig($this,outx)
		    gets $fid _THLinesConfig($this,tabl)
		    gets $fid _THLinesConfig($this,chis)
		}
	    }
	    close $fid

	} else {
	    set _THLinesConfig($this,outx) 500
	    set _THLinesConfig($this,tabl) 50
	    set _THLinesConfig($this,chis) 20
	}

    }

    method save {} {
	global _THLinesConfig
	
	set f   [$CFilM getHLinesFile]	
	set fid [open $f "w"]
	puts $fid 1 ;# version
	puts $fid $_THLinesConfig($this,outx)
	puts $fid $_THLinesConfig($this,tabl)
	puts $fid $_THLinesConfig($this,chis)
	close $fid

	$CMudder adjustHLines \
	    $_THLinesConfig($this,outx) \
	    $_THLinesConfig($this,tabl) \
	    $_THLinesConfig($this,chis)

	deactivate
    }

    method canc {} { deactivate }

    method increm {aaa} {
	global _THLinesConfig
	if {![string compare "" $_THLinesConfig($this,$aaa)]} {
	    set _THLinesConfig($this,$aaa) 1
	}
	incr _THLinesConfig($this,$aaa) 5
    }
    method decrem {aaa} {
	global _THLinesConfig
	if {![string compare "" $_THLinesConfig($this,$aaa)]} {
	    set _THLinesConfig($this,$aaa) 1
	}
	incr _THLinesConfig($this,$aaa) -5
	if {$_THLinesConfig($this,$aaa) < 1} {
	    set _THLinesConfig($this,$aaa) 1	    
	}
    }

}




# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: THLinesConfig.tcl,v $
# Revision 1.2  2001/08/19 12:25:42  issever
# Added the cvs keywords Id at start of the file
# and Log at the end of the file
#
#
