# $Id: TImage.tcl,v 1.3 2001/08/19 12:25:42 issever Exp $

#=======================================================
class TImage {
    inherit TCNObject

    private variable CImage       ;# the image     
    private variable CImageManager

    constructor {aType aCategory aName aPath aImaM} {
	TCNObject::constructor $aType $aCategory $aName
    } {
	set CImage      [image create photo -file $aPath]
	set CImageManager $aImaM
    }
    method getImage {} { return $CImage }
    method streamout {} { return [TCNId]}
}
#=======================================================
class TImageManager {
    inherit TCNContainer

    private variable CImagePath         ;# master path to all images

    constructor {aPath} {
	TCNContainer::constructor
    } {
	set CImagePath $aPath
    }

    method ddfLoad {aTypeDir} {
	global SMM
	
	if {$SMM(devmode)} {
	    switch -- $aTypeDir {
		"bg_bw_ontop" {
		    set category misc
		    set fileName def
		    set imageFile [file join $CImagePath $aTypeDir $category $fileName.gif]
		    add [TImage ::\#auto $aTypeDir $category $fileName $imageFile $this]
		}
		"stuff" {
		    set category misc
		    set fileName stuff
		    set imageFile [file join $CImagePath $aTypeDir $category $fileName.gif]
		    add [TImage ::\#auto $aTypeDir $category $fileName $imageFile $this]
		}
		"system" {
		    foreach categoryDir [glob -- [file join $CImagePath $aTypeDir *]] {
			set category   [file tail $categoryDir]
			foreach imageFile [glob -- [file join $categoryDir *]] {
			    set fileName [file rootname [file tail $imageFile]]
			    loadmeter2 "Loading image: $aTypeDir | $category | $fileName"
			    add [TImage ::\#auto $aTypeDir $category $fileName $imageFile $this]
			}	
		    }
		}
	    }
	} else {
	    foreach categoryDir [glob -nocomplain -- [file join $CImagePath $aTypeDir *]] {		
		set category   [file tail $categoryDir]
		if {[string match CVS $category]} { continue }
		foreach imageFile [glob -nocomplain -- [file join $categoryDir *]] {
		    if {[string match "*CVS" $imageFile]} { continue }
		    set fileName [file rootname [file tail $imageFile]]
		    loadmeter2 "Loading image: $aTypeDir | $category | $fileName"
		    add [TImage ::\#auto $aTypeDir $category $fileName $imageFile $this]
		}	
	    }
	}
    }
    method getImage {t c n} {
	return [[getObject $t $c $n] getImage]
    }
    method streamin  {arg} { 
	return [getObject [lindex $arg 0] [lindex $arg 1] [lindex $arg 2]]
    }
    method streamin_BGV1ToV2  {arg} { 
	set type [lindex $arg 0]
	set cate [lindex $arg 1]
	set name [lindex $arg 2]

	global tcl_platform
	switch -- $tcl_platform(platform) {
	    "unix" {
		switch -exact -- "$type/$cate" {
		    bg-below/landscape  {
			set type bg_color_below
			set cate landscape
		    }       
		    bg-ontop/Buildings  { 
			set type bg_bw_ontop
			set cate buildings           
		    }       
		    bg-ontop/Landscape  { 
			set type bg_bw_ontop
			set cate landscape           
		    }       
		    bg-ontop/Misc       {      
			set type bg_bw_ontop
			set cate misc                
		    }       
		    bg-ontop/Walls      {      
			set type bg_bw_ontop
			set cate walls               
		    }       
		    bg-ontop/buildings  {      
			set type bg_color_ontop
			set cate buildings        
		    }       
		    bg-ontop/misc       {      
			set type bg_bw_ontop
			set cate misc                
		    }       
		    bg-ontop/roads      {      
			set type bg_color_ontop
			set cate roads            
		    }       
		    bg-ontop/walls      {      
			set type bg_color_ontop
			set cate walls            
		    }       
		}
	    }
	    default {
		# means win
		switch -exact -- [string tolower $type] {
		    bg-below {
			set type bg_color_below
			set cate landscape			
		    }
		    bg-ontop {
			switch -exact -- [string tolower $cate] {
			    landscape {
				set type bg_bw_ontop
				set cate landscape           
			    }
			    roads {
				set type bg_color_ontop
				set cate roads            
			    }
			    misc {
				set type bg_bw_ontop
				set cate misc                
			    }
			    buildings {
				switch $name {
				    inn -
				    tower {
					set type bg_color_ontop
					set cate buildings        
				    }
				    default {
					set type bg_bw_ontop
					set cate buildings           
				    }
				}
			    }
			    walls {
				switch $name {
				    e -
				    n -
				    ne -
				    nw -
				    s -
				    se -
				    sw -
				    w {
					set type bg_color_ontop
					set cate walls            
				    }
				    default {
					set type bg_bw_ontop
					set cate walls               
				    }
				}
			    }
			}
		    }
		}
	    }
	}
	return [getObject $type $cate $name]
    }

}

#=======================================================
#=======================================================
#=======================================================



# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TImage.tcl,v $
# Revision 1.3  2001/08/19 12:25:42  issever
# Added the cvs keywords Id at start of the file
# and Log at the end of the file
#
#
