# $Id: TInformer.tcl,v 1.3 2001/12/07 23:48:38 issever Exp $

class TInformer {
    inherit iwidgets::Messagedialog
    private variable CAfterId

    itk_option define -information  information  Information  "Be careful!"
    itk_option define -vanishafter  time         Time         0
    itk_option define -hide         hide         Hide         destroy
    itk_option define -autoactivate autoActivate AutoActivate 1
    constructor {args} {
	configure -title "Notice"
	configure -bitmap info
	configure -modality application
	configure -padx 10
	configure -pady 10
	configure -textpadx 20
	configure -textpady 20

	set CAfterId -1

	set tlparent [winfo toplevel [winfo parent [winfo toplevel $itk_interior]]]
	configure -master $tlparent
	configure -tops $tlparent
	
	buttonconfigure OK -text "OK" -command "[code $this closeit]"
	hide Cancel
	hide Help	

	eval itk_initialize $args
	if {$itk_option(-autoactivate)} { activate }
    }
    method activate {} {
	iwidgets::Shell::center $itk_option(-master)
	if {$itk_option(-vanishafter)>0} {
	    if {$CAfterId == -1 } {
		set CAfterId "[after [expr 1000*$itk_option(-vanishafter)] [code $this closeit]]"
	    }
	}	
	iwidgets::Shell::center
	iwidgets::Shell::activate
    }
    private method closeit {} {
	iwidgets::Shell::deactivate
	if {$CAfterId>0} {
	    after cancel $CAfterId
	}
	set CAfterId -1
	if {[string compare "destroy" $itk_option(-hide)] == 0} {
	    ::delete object $this
	}
    }
}
#=========================================================================
configbody TInformer::hide {
}
configbody TInformer::information {
    configure -text $itk_option(-information)
}
configbody TInformer::vanishafter {
    if {$itk_option(-vanishafter)>0} {
	set CAfterId "[after [expr 1000*$itk_option(-vanishafter)] [code $this closeit]]"
    }
}
###########################################################################
###########################################################################
###########################################################################
class TConfirmer {
    inherit iwidgets::Messagedialog

    itk_option define -question question Question "Really?"
    itk_option define -command command Command "puts Duh."

    constructor {args} {
	configure -title "Question"
	configure -bitmap questhead
	configure -modality application
	configure -padx 10
	configure -pady 10
	configure -textpadx 20
	configure -textpady 20

	
	set tlparent [winfo toplevel [winfo parent [winfo toplevel $itk_interior]]]
	configure -master $tlparent
	configure -tops $tlparent

	buttonconfigure OK     -text "Yes" -command "[code $this launchCommand]"
	buttonconfigure Cancel -text "No"  -command "[code $this closeit]"
	hide Help	
	default Cancel

	eval itk_initialize $args
	
	center
	activate
    }
    private method launchCommand {} {
	eval $itk_option(-command)
	closeit
    }
    private method closeit {} {
	::delete object $this
    }
}
#=========================================================================
configbody TConfirmer::question {
    configure -text $itk_option(-question)
}
configbody TConfirmer::command {    }



# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TInformer.tcl,v $
# Revision 1.3  2001/12/07 23:48:38  issever
# Session and Mud Manager totally redone.
# They are now put into one window.
#
# Revision 1.2  2001/08/19 12:25:42  issever
# Added the cvs keywords Id at start of the file
# and Log at the end of the file
#
#
