# $Id: TLimitedFIFO.tcl,v 1.2 2001/08/19 12:25:42 issever Exp $

class TLimitedFIFO {
    private variable CSize
    private variable CActPos
    private variable CFIFO

    constructor {aSize} {
	set CSize   $aSize
	set CActPos -1

	for {set i 0} {$i<$CSize} {incr i} {
	    set CFIFO($i) ""
	}
    }

    method resize {aSize} {

	for {set i 0} {$i<$CSize} {incr i} {
	    unset CFIFO($i)
	}
	set CSize $aSize
	for {set i 0} {$i<$CSize} {incr i} {
	    set CFIFO($i) ""
	}

    }

    method insert {aStr} {
	if {[string compare "" "$aStr"]==0} {
	    resetPos
	    return
	}
	if {[string compare "$CFIFO(0)" "$aStr"]==0} {
	    resetPos
	    return
	}
	set i [expr $CSize -2]
	set j [expr $CSize -1]
	for {} {$i>-1} {incr i -1; incr j -1} {
	    set CFIFO($j) $CFIFO($i)
	}
	set CFIFO(0) $aStr
	resetPos
    }
    method resetPos {} {
	set CActPos -1
    }
    method getLast {} {
	return $CFIFO(0)
    }
    method getUp {} {
	incr CActPos
	if {$CActPos == $CSize} {
	    bell
	    incr CActPos -1
	}
	return $CFIFO($CActPos)
    }
    method getDown {} {
	incr CActPos -1
	if {$CActPos < 0} {
	    bell
	    resetPos
	    return ""
	}
	return $CFIFO($CActPos)
    }

}



# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TLimitedFIFO.tcl,v $
# Revision 1.2  2001/08/19 12:25:42  issever
# Added the cvs keywords Id at start of the file
# and Log at the end of the file
#
#
