# $Id: TLoadFeedback.tcl,v 1.2 2001/08/19 12:25:42 issever Exp $

class TMessenger {
    inherit itk::Widget

    constructor {title args} {
	set wid $itk_interior.f

	itk_component add mainframe {
	    iwidgets::scrolledframe $wid -relief ridge -borderwidth 2 \
		-width 600 -height 300 -sbwidth 10 -background "\#daceaf"
	    #frame $wid -relief ridge -bd 2 
	} {usual}
	pack $itk_component(mainframe) -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0

	itk_component add tit {
	    label [$itk_component(mainframe) childsite].msgtit -bd 2 -relief raised -bg blue -fg white \
		-justify center -text $title -font "courier" 
	} {ignore -background}
	pack $itk_component(tit) \
	    -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0 -side top

	set n 1
	foreach mmm $args {
	    itk_component add mframe$n {
		frame [$itk_component(mainframe) childsite].f$n -relief ridge -bd 2 } {keep -background}
	    pack $itk_component(mframe$n) -side top -fill both -expand true -ipadx 10 -ipady 10 -padx 0 -pady 0

	    itk_component add n$n {
		label $itk_component(mframe$n).n -justify left \
		    -anchor w -width 3\
		    -bd 0 -relief ridge -bg blue -fg white \
		    -text "$n)" -font "courier"
	    } { ignore -background }
	    pack $itk_component(n$n) \
		-fill both -expand 0 -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left
	    itk_component add msg$n {
		label $itk_component(mframe$n).msg -justify left \
		    -anchor w\
		    -bd 0 -relief ridge -bg blue -fg white \
		    -text "$mmm" -font "courier"
	    } { ignore -background }
	    pack $itk_component(msg$n) \
		-fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left
	    incr n
	}

    }
}

class TLoadFeedback {
    inherit iwidgets::Mainwindow

    variable CToplevel
    variable CNum
    constructor {aNumSteps aSrcPath args} {
	global SMM
	configure -title "SMM++ Loadmeter"
	configure -helpline 0
	configure -statusline 0

	configure -background "\#daceaf"

	set    m0 "This Loadmeter will be destroyed 2 minutes after SMM++\n"
	append m0 "has been started. So you still have enough time\n"
	append m0 "to read all the information here."

	set    m1 "If loading takes to long for you, please read:\n"
	append m1 "[file join $aSrcPath docu CUSTOMIZE_SMM]\n\n"
	append m1 "And always keep in mind: Good magic needs its time!\n"
	append m1 "Haste leads to failure, failure to anger, anger to hate\n"
	append m1 "and hate to the bad side of magic!"

	set    n1 "If you have mapped your mud or parts of it, please\n"
	append n1 "provide them to us, so all can profit from your work!\n"
	append n1 "For more information please read:\n"
	append n1 "[file join $aSrcPath docu MAPS]"

	set    n2 "Please also provide us your scriptfiles, so I\n"
	append n2 "can include them into the distribution.\n"
	append n2 "Please keep in mind: What is good for you, is good\n"
	append n2 "for others too! Let all profit from your experience\n"
	append n2 "and knowledge. For more information please read:\n"
	append n2 "[file join $aSrcPath docu SCRIPTS]"

	set    m2 "Please, comment and rate SMM++ at 'The Linux Game Tome'\n"
	append m2 "You can find the link to there on the SMM++ homepage:\n"
	append m2 "Under 'Index', 'Kindly asking for', element 1"

	set    m3 "If you find time, please, fill out the feedback form\n"
	append m3 "and send it back to me (selim.issever@desy.de).\n"
	append m3 "It would be great, if you could fill it out every couple\n"
	append m3 "of upgrades. The feedback form is located at:\n"
	append m3 "[file join $aSrcPath docu FEEDBACK]"

	set    m4 "Ever thought about putting a 'download SMM++' button\n"
	append m4 "or link onto your webpages?! Or even a banner? You can\n"
	append m4 "download the images from the SMM++ homepage."

	set CToplevel [winfo toplevel $itk_interior]
	wm geometry $CToplevel +0+0

	itk_component add title {
	    label [$this childsite].tit -text "Thank you for using SMM++! (Version $SMM(version))"
	} { keep -background }
	itk_component add loadmeter {
	    iwidgets::feedback [$this childsite].lm -labeltext "Load and Build Status" \
		-steps [expr $aNumSteps+1] -barcolor "\#a59575"
	} { keep -background }
	itk_component add statstring {
	    label [$this childsite].stat -textvariable __TLoadFeedback($this,1) \
		-width 60 -relief sunken
	} { keep -background }
	itk_component add statstring2 {
	    label [$this childsite].stat2 -textvariable __TLoadFeedback($this,2) \
		-width 60 -relief sunken -justify left -anchor nw
	} { keep -background }

	itk_component add msg {
	    TMessenger [$this childsite].msg "Information" $m0 $m1 $n1 $n2 $m2 $m3 $m4
	} {ignore -background}

	pack $itk_component(title) \
	    $itk_component(loadmeter) \
	    $itk_component(statstring) $itk_component(statstring2) \
	    $itk_component(msg) \
	    -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0 -side top

	$itk_component(loadmeter) reset
	activate
	eval itk_initialize $args
	set CNum 0
    }
    method nextStatus {aString} {
	global __TLoadFeedback
	set __TLoadFeedback($this,1) $aString
	set __TLoadFeedback($this,2) ""	
	homework
    }
    method nextSubStatus {aString} {
	global __TLoadFeedback
	set __TLoadFeedback($this,2) $aString
	homework
    }
    method ready {} {
	global __TLoadFeedback
	set __TLoadFeedback($this,1) "Ready!"
	set __TLoadFeedback($this,2) ""	
	$itk_component(loadmeter) step
	update

	after 120000 "destroy $CToplevel"
    }


    private method homework {} {
	$itk_component(loadmeter) step
	raise $CToplevel
	update 

	###############################################################
	### enable this, if you want know the "max feedback number".
	#global __TLoadFeedback
	#incr CNum
	#puts "$CNum: \[$__TLoadFeedback($this,1) | $__TLoadFeedback($this,2)\]"
    }

}


# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TLoadFeedback.tcl,v $
# Revision 1.2  2001/08/19 12:25:42  issever
# Added the cvs keywords Id at start of the file
# and Log at the end of the file
#
#
