# $Id: TMouseButtonConfig.tcl,v 1.5 2002/04/06 22:49:39 issever Exp $

class TMouseButtonConfigurer {
    inherit iwidgets::Texteddialog
    
    variable _filM
    variable _nwid

    variable _cci
    variable _ccj
    variable _ea

    constructor {aFilM args} {
	configure -foreground black
	addFGCom [code $this configure -foreground %c] 

	set _filM   $aFilM

	configure -title "SMM++ Mouse Button Configuration"
	configure -modality application
	configure -text "Here you can set how 'middle-' and 'right-mousebutton-click' events are invoked.\
                       \nSo if you dont have a three button mouse, you can redirect the events and\
                         still access all SMM's functionality.\
                         If you accept, your changes will be saved, too."
	configure -aspect 333
	buttonconfigure OK       -text "Accept"    -command "[code $this save]"     -foreground black
	add             Defaults -text "Defaults"  -command "[code $this defaults]" -foreground black
	buttonconfigure Cancel   -text "Reset"     -command "[code $this reset]"    -foreground black
	addFGCom [code $this buttonconfigure OK       -foreground %c] 
	addFGCom [code $this buttonconfigure Defaults -foreground %c] 
	addFGCom [code $this buttonconfigure Cancel   -foreground %c] 

	# -- configurer
	set wid [$this childsite]

	set _nwid 0
	# b: number of mouse button
	# d: souble or not
	# s: shift
	# c: control
	# a: alt
	foreach {text b d s c a en ed} {
	    "ZIF shortcut: "        2 0 0 0 0 "<<ZIFShortcut>>"           "<Button-2>"
	    "ZIF extented: "        3 0 0 0 0 "<<ZIFExtended>>"           "<Button-3>"
	    "Map primary: "         1 0 0 0 0 "<<MapPrimary>>"            "<Button-1>"
	    "Map place player: "    1 1 0 0 0 "<<MapPlacePlayer>>"        "<Double-1>"
	    "Map powerwalk: "       2 1 0 0 0 "<<MapPowerwalk>>"          "<Double-2>"
	    "Map select: "          1 0 0 0 1 "<<MapSelect>>"             "<Alt-Button-1>"
	    "Map unselect: "        2 0 0 0 1 "<<MapUnSelect>>"           "<Alt-Button-2>"
	    "Map toggle: "          3 0 0 0 1 "<<MapToggleSelect>>"       "<Alt-Button-3>"
	    "Map select region: "   1 1 0 0 1 "<<MapSelectRegion>>"       "<Alt-Double-1>"
	    "Map unselect region: " 2 1 0 0 1 "<<MapUnSelectRegion>>"     "<Alt-Double-2>"
	    "Map toggle region: "   3 1 0 0 1 "<<MapToggleSelectRegion>>" "<Alt-Double-3>"
	} {
	    set _ea($_nwid,dl) [list $b $d $s $c $a]
	    set _ea($_nwid,en) $en
	    set _ea($_nwid,ed) $ed
	    event add $en $ed

	    itk_component add a$_nwid {
		TButtonEventAdjuster $wid.a$_nwid $text $b $d $s $c $a
	    } { keep -background }
	    pack $itk_component(a$_nwid) -side top -fill both -expand true \
		-ipadx 0 -ipady 0 -padx 0 -pady 0 
	    incr _nwid
	}
	event add "<<DragNDroping>>"   "<ButtonPress-1><Button1-Motion>"
	event add "<<DragNDropEnd>>"   "<ButtonPress-1><Button1-Motion><ButtonRelease-1>"

	eval itk_initialize $args	
	loadMouserc
	adjustBindings

    }    
    method defaults {} {
	for {set i 0} {$i<$_nwid} {incr i} {
	    $itk_component(a$i) streamin $_ea($i,dl)
	}
	adjustBindings
    }
    method checkClashes {args} {
	set sl $args
	while {[llength $sl]>=2} {
	    set _cci [lindex $sl 0]
	    set sl [lrange $sl 1 end]
	    foreach _ccj $sl {
		set is [$itk_component(a$_cci) getEventString] 
		set js [$itk_component(a$_ccj) getEventString]
		if {[string compare $is $js]==0} {
		    # clash
		    puts "|$is|$js|"
		    return 1
		}
	    }
	}
	return 0
    }
    method adjustBindings {} {
	for {set i 0} {$i<$_nwid} {incr i} {
	    $itk_component(a$i) clash 0
	}
	if {[checkClashes 0 1]} {
	    $itk_component(a$_cci) clash 1
	    $itk_component(a$_ccj) clash 1
	    bell
	    return 1
	}
	if {[checkClashes 2 3 4 5 6 7 8 9 10]} {
	    $itk_component(a$_cci) clash 1
	    $itk_component(a$_ccj) clash 1
	    bell
	    return 1
	}

	for {set i 0} {$i<$_nwid} {incr i} {
	    event delete $_ea($i,en)
	    event add    $_ea($i,en) [$itk_component(a$i) getEventString]
	    $itk_component(a$i) remReset
	}

	event delete "<<DragNDroping>>"
	event delete "<<DragNDropEnd>>"
	event add "<<DragNDroping>>" [$itk_component(a2) getDNDingString]
	event add "<<DragNDropEnd>>" [$itk_component(a2) getDNDEndString]

	return 0
    }
    method loadMouserc {} {
	set f [$_filM getMouserc]	

	if {[file exists $f]} {
	    set fid [open $f "r"]
	    gets $fid version

	    switch -- $version {
		2 {
		    for {set i 0} {$i<$_nwid} {incr i} {
			$itk_component(a$i) streamin [gets $fid]
		    }
		    adjustBindings
		}
		1 {
		    puts "Old .mouserc."
		}
		default {
		    error "Unknown version '$version' for mouserc!"
		}
	    }	    
	    close $fid
	} 

    }


    method save {} {
	if {[adjustBindings]} {
	    return
	}
	set f   [$_filM getMouserc]	

	set fid [open $f "w"]
	puts $fid 2 ;# version
	
	for {set i 0} {$i<$_nwid} {incr i} {
	    puts $fid [$itk_component(a$i) streamout]
	}

	close $fid
	deactivate
    }

    method reset {} { 
	for {set i 0} {$i<$_nwid} {incr i} {
	    $itk_component(a$i) reset
	}
	adjustBindings
    }

}

class TButtonEventAdjuster {
    inherit itk::Widget

    variable _buttonNr
    variable _modShift
    variable _modControl
    variable _modAlt
    variable _modDouble
    
    method getEventString {} {
	set es ""
	if {$_modShift}   { append es "-Shift" }
	if {$_modControl} { append es "-Control" }
	if {$_modAlt}     { append es "-Alt" }
	if {$_modDouble}  { 
	    append es "-Double" 
	} else {
	    append es "-Button" 
	}
	append es "-$_buttonNr"
	return "<[string range $es 1 end]>"
    }
    method clash {aClash} {
	if {$aClash} {
	    $itk_component(tit) configure -foreground red
	} else {
	    $itk_component(tit) configure -foreground black
	}
    }
    variable _rem
    method getDNDingString {} { 
	return "<ButtonPress-$_rem(b)><Button$_rem(b)-Motion>"
    }
    method getDNDEndString {} { 
	return "<ButtonPress-$_rem(b)><Button$_rem(b)-Motion><ButtonRelease-$_rem(b)>"
    }
    method remReset {} {
	set _rem(b) $_buttonNr   
	set _rem(d) $_modDouble  
	set _rem(s) $_modShift   
	set _rem(c) $_modControl 
	set _rem(a) $_modAlt     
    }
    method reset {} {
	set _buttonNr   $_rem(b)    
	set _modDouble  $_rem(d)  
	set _modShift   $_rem(s)   
	set _modControl $_rem(c) 
	set _modAlt     $_rem(a)     
    }
    method streamout {} {
	return [list $_buttonNr $_modDouble $_modShift $_modControl $_modAlt]
    }
    method streamin {aData} {
	set _buttonNr   [lindex $aData 0]
	set _modDouble  [lindex $aData 1]
	set _modShift   [lindex $aData 2]
	set _modControl [lindex $aData 3]
	set _modAlt     [lindex $aData 4]
	remReset	
    }
    constructor {text bnr d s c a args} {
	set _buttonNr   $bnr
	set _modDouble  $d
	set _modShift   $s
	set _modControl $c
	set _modAlt     $a
	remReset

	itk_component add mf { frame $itk_interior.mf -bd 2 } { keep -background }
	pack $itk_component(mf) -side bottom -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0

	itk_component add tit {
	    label $itk_component(mf).tit -text $text -font def -bd 2 -relief sunken -anchor w
	} { keep -background }
	pack $itk_component(tit) -side left -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0
	
	# select mouse button
	itk_component add buts { frame $itk_component(mf).buts -bd 2 -relief sunken 
	} { keep -background }
	pack $itk_component(buts) -side left -fill both -expand 0 -ipadx 0 -ipady 0 -padx 0 -pady 0
	for { set i 1 } { $i<=3 } { incr i } {
	    itk_component add but$i {
		radiobutton $itk_component(buts).b$i -text $i -value $i -variable [scope _buttonNr] -fg black
	    } { keep -background }
	    pack $itk_component(but$i) -side left -fill both -expand true \
		-ipadx 0 -ipady 0 -padx 0 -pady 0
	}

	# select modifiers
	itk_component add mods { frame $itk_component(mf).mods -bd 2 -relief sunken 
	} { keep -background }
	pack $itk_component(mods) -side left -fill both -expand 0 -ipadx 0 -ipady 0 -padx 0 -pady 0
	foreach m {Double Shift Control Alt} {
	    itk_component add mod$m {
		checkbutton $itk_component(mods).mod$m -text $m -variable "[scope _mod$m]" -fg black
	    } { keep -background }
	    pack $itk_component(mod$m) -side left -fill both -expand true \
		-ipadx 0 -ipady 0 -padx 0 -pady 0
	}


	eval itk_initialize $args	
    }

}




# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TMouseButtonConfig.tcl,v $
# Revision 1.5  2002/04/06 22:49:39  issever
# drag&drop bound to cut/copy/paste (in maps).
# This allows to d&d more then a single room at once.
#
# Revision 1.4  2002/04/04 21:07:03  issever
# Optimized the expr's, which are used in the mapping code.
# Splited the File TEXit.tcl.
#
# Revision 1.3  2002/02/17 17:48:27  issever
# resolving merging errors.
#
# Revision 1.2  2001/08/19 12:25:42  issever
# Added the cvs keywords Id at start of the file
# and Log at the end of the file
#
#
