# $Id: TNVContainer.tcl,v 1.2 2001/08/19 12:25:42 issever Exp $

# name/value container

class TNVContainer {
    variable CHelperList1
    variable CHelperList2
    variable Cstrl
    constructor {} {
	set Cstrl [string length "$this,"]
    }
    destructor { 
	clear 
    }
    method exists {aName} { 
	global _TNVContainer
	return [info exists _TNVContainer($this,$aName)] 
    }
    method rem {aName} { 
	global _TNVContainer
	if {[exists $aName]} { unset _TNVContainer($this,$aName) } 
    }
    method add {aName aValue} { 
	global _TNVContainer
	set _TNVContainer($this,$aName) $aValue 
    }
    private method stripThis {} {
	set CHelperList2 [list]
	foreach elem $CHelperList1 {
	    lappend CHelperList2 [string range $elem $Cstrl end]
	}
    }
    method getGlobalVarName {}      { return "_TNVContainer" }
    method getVarName       {aName} { return "_TNVContainer($this,$aName)"}
    method getAllNames {} { 
	global _TNVContainer
	set CHelperList1 [array names _TNVContainer "$this,*"]
	stripThis
	return [lsort $CHelperList2] 
    }
    method getAllMatching {aPattern} { 
	global _TNVContainer
	set CHelperList1 [array names _TNVContainer "$this,$aPattern"]
	stripThis
	return [lsort $CHelperList2] 
    }
    method getValue {aName} { 
	global _TNVContainer
	if {[exists $aName]} { 
	    return $_TNVContainer($this,$aName) 
	} else {
	    return "" 
	} 
    }
    method clear {} { 
	foreach name [getAllNames] { rem $name } 
    }
    method isEmpty {} { 
	if { [llength [getAllNames]] == 0 } {
	    return 1 
	} else { 
	    return 0 
	} 
    }
    method isntEmpty {} { 
	if { [llength [getAllNames]] != 0 } { 
	    return 1 
	} else { 
	    return 0
	} 
    }
    method isMatching {aPattern} { 
	if { [llength [getAllMatching "$aPattern"]] == 0 } { 
	    return 1 
	} else {
	    return 0 
	} 
    }
    method isntMatching {aPattern} { 
	if { [llength [getAllMatching "$aPattern"]] != 0 } {
	    return 1 
	} else { 
	    return 0 
	} 
    }

}






# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TNVContainer.tcl,v $
# Revision 1.2  2001/08/19 12:25:42  issever
# Added the cvs keywords Id at start of the file
# and Log at the end of the file
#
#
