# $Id: TSecondaryWindow.tcl,v 1.2 2001/08/19 12:25:42 issever Exp $

class TSecondaryWindow {
    inherit itk::Widget

    variable CParent 
    variable CWinWid

    variable CFocusWasAt
    variable CGrabWasAt

    itk_option define -title title Title "SMM"

    common CFocusList
    common CGrabList

    constructor {args} {

	regsub -- {^::} $this {} CWinWid
	regsub -- {[^.]*$} $CWinWid {} helper
	regsub -- {\.$} $helper {} CParent

	set CFocusWasAt ""
	set CGrabWasAt  ""

	if {![info exists CFocusList]} {
	    set CFocusList [list]
	    set CGrabList  [list]
	}

	#########################################################################
	# a frame around all
 	itk_component add   mmmainframe {
	    frame $itk_interior.mainframe -relief raised -bd 2 -background $TColor::BGWinBorder
	} {ignore -background}
 	pack $itk_component(mmmainframe) -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0

 	itk_component add   mmainframe {
	    frame $itk_component(mmmainframe).mainframe -relief flat -bd 2 -background $TColor::BGWinBorder
	} {ignore -background}
 	pack $itk_component(mmainframe) -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0

 	itk_component add   mainframe {
	    frame $itk_component(mmainframe).mainframe -relief sunken -bd 2 -background $TColor::BGWinBorder
	} {ignore -background}
 	pack $itk_component(mainframe) -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0

	
	#########################################################################
	# label
 	itk_component add   title {
	    label $itk_component(mainframe).title \
		-relief raised -bd 2 -font title -background $TColor::BGWinBorder
	} {ignore -background}
 	pack $itk_component(title) -side top -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0
	
	#########################################################################
	# create the hull
 	itk_component add   hulli {
	    frame $itk_component(mainframe).hulli -relief flat -bd 0 -background $TColor::BGdef
	} {ignore -background}
 	pack $itk_component(hulli) -fill both -expand true -ipadx 0 -ipady 0 -padx 0 -pady 0
	
	eval itk_initialize $args

    }
    destructor {
	deactivate
    }
    method childsite {} { return $itk_component(hulli) }
    method activate {} {
	if {[llength $CFocusList] == 0} { lappend CFocusList [focus] }
	if {[llength $CFocusList] == 0} { lappend CGrabList  [grab current] }

	raise $itk_interior
	place $itk_interior -in $CParent \
	    -relx 0.5 -rely 0.5 \
	    -anchor center
	tkwait visibility $itk_interior
	focus $itk_interior
	grab  $itk_interior

	lappend CFocusList $itk_interior
	lappend CGrabList  $itk_interior

    }
    method deactivate {} { 
	# adjust lists
	while {1} {
	    set i [lsearch -glob $CFocusList "$itk_interior*"]
	    if {$i==-1} { break }
	    set CFocusList [lreplace $CFocusList $i $i]
	}
	while {1} {
	    set i [lsearch -glob $CGrabList "$itk_interior*"]
	    if {$i==-1} { break }
	    set CGrabList [lreplace $CGrabList $i $i]
	}

	# set focus
	set f [lindex $CFocusList end]
	if {[string compare "" $f]} {
	    focus $f
	} 
	# set grab
	set g [lindex $CGrabList end]
	if {[string compare "" $g]} {
	    grab  $g
	} else {
	    grab  release $itk_interior
	}
	if {[llength $CFocusList]<2} {set CFocusList [list]}
	if {[llength $CGrabList]<2}  {set CGrabList  [list]}
	
	# now vanish
	place forget  $itk_interior
	
    }
    method deactivateold {} { 
	# set focus
	if {[string compare "" $CFocusWasAt]} {
	    focus $CFocusWasAt
	}
	# set grab
	if {[string compare "" $CGrabWasAt]} {
	    grab  $CGrabWasAt
	} else {
	    grab  release $itk_interior
	}
	# now vanish
	place forget  $itk_interior
    }
    method activateold {} {
	set CFocusWasAt [focus]
	set CGrabWasAt  [grab current]
	raise $itk_interior
	place $itk_interior -in $CParent \
	    -relx 0.5 -rely 0.5 \
	    -anchor center
	tkwait visibility $itk_interior
	focus $itk_interior
	grab  $itk_interior
    }


}

#=========================================================================
configbody TSecondaryWindow::title {
    $itk_component(title) configure -text $itk_option(-title)
}





# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: TSecondaryWindow.tcl,v $
# Revision 1.2  2001/08/19 12:25:42  issever
# Added the cvs keywords Id at start of the file
# and Log at the end of the file
#
#
