# $Id: startup.tcl,v 1.3 2002/05/10 07:33:20 issever Exp $

#----------------------------------------------------
# evaluate command line parameters
for {set i 0} {$i<$argc} {incr i} {
    set clp [lindex $argv $i]
    switch -- $clp {
	"-mapwindow" -
	"-mw" {
	    set SMMMAPWINDOW 1
	}
	"-nomapwindow" -
	"-nmw" {
	    set SMMMAPWINDOW 0
	}
	default {
	    puts "ERROR: '$clp' unknown command line parameter"
	    puts "Must be one of the following:"
	    puts "  -mapwindow, -mw"
	    puts "  -nomapwindow, -nmw"
	    exit
	}
    }
}
#----------------------------------------------------
global SMM
set SMM(version) 6.0.1
if {[info exists DEVMODE]} {
    set SMM(devmode) 1
} else {
    set SMM(devmode) 0
}

wm title . "SMM++"
message .smmstartupmsg -bg white -aspect 1500 -justify center \
    -text "Starting SMM++ (Version $SMM(version)).\nLoading libraries and precompiling code.\nPlease, be patient."
pack .smmstartupmsg 
update

#-------------------------------------------------
# The client will talk with the smm homesite via http.
package require http

#-------------------------------------------------
# Trf handles on-the-fly stream zlib uncompression and
# Tclx provides a pipe, both are needed for MCCP support.
catch {package require Trf}
catch {package require Tclx}

#----------------------------------------------------
# adjust the user dir, if requested
if {[info exists env(SMMPATH)]} {
    set SMMPATH $env(SMMPATH)
}

#----------------------------------------------------
lappend auto_path [file join $SMMSRCPATH sources]
lappend auto_path [file join $SMMSRCPATH sources main]
lappend auto_path [file join $SMMSRCPATH sources mudding]
lappend auto_path [file join $SMMSRCPATH sources mapping]
lappend auto_path [file join $SMMSRCPATH sources rsc]
lappend auto_path [file join $SMMSRCPATH sources itcl iwidgets generic]
lappend auto_path [file join $SMMSRCPATH sources editor]
lappend auto_path [file join $SMMSRCPATH sources error]


if {[info exists TCLPATH]} {
    set SMMIWIDGETSPATH [file join $TCLPATH lib iwidgets3.0.0]
}
if {[info exists SMMIWIDGETSPATH]} {
    lappend auto_path $SMMIWIDGETSPATH
}


set iwidgetsversion [package require Iwidgets]
if {[regexp -- {^4\..*} $iwidgetsversion]} {
    namespace import itcl::*
}
source [file join $SMMSRCPATH sources itcl iwidgets generic line.tcl]

source [file join $SMMSRCPATH sources itcl iwidgets generic shell.tcl]
source [file join $SMMSRCPATH sources itcl iwidgets generic dialogshell.tcl]
source [file join $SMMSRCPATH sources itcl iwidgets generic texteddialog.tcl]
source [file join $SMMSRCPATH sources itcl iwidgets generic labeledwidget.tcl]
source [file join $SMMSRCPATH sources itcl iwidgets generic panedwindow.tcl]

source [file join $SMMSRCPATH sources itcl iwidgets generic fontconfig.tcl]
source [file join $SMMSRCPATH sources itcl iwidgets generic fontmanager.tcl]

source [file join $SMMSRCPATH sources itcl iwidgets generic colormanager.tcl]



if {[info exists TROUBLE(optionmenu)]} {
    source [file join $SMMSRCPATH bin optionmenu.itk]
}

#----------------------------------------------------
#----------------------------------------------------

#----------------------------------------------------
#----------------------------------------------------
#TLoadFeedback .smmLoadmeter 157 $SMMSRCPATH 
#proc loadmeter  {aString} { .smmLoadmeter nextStatus $aString }
#proc loadmeter2 {aString} { .smmLoadmeter nextSubStatus $aString }
proc loadmeter  {aString} {  }
proc loadmeter2 {aString} {  }

#----------------------------------------------------
loadmeter "Building filesystem manager."
TFileSystemManager film $SMMPATH $SMMSRCPATH

#----------------------------------------------------
loadmeter "Building GUI manager."
TGUI  guim film
[guim getColorManager] add "FG def GUI" FGGuiDef black 2
proc addFGCom {com} {
    [guim getColorManager] addCommand FGGuiDef $com
}
guim addGUIColors

#---------------------------------------------------
loadmeter "Building version info."
set    SMM(vinfstr) "Version:     $SMM(version)\n"
append SMM(vinfstr) "User path:   $SMMPATH\n"
append SMM(vinfstr) "SMM sources: $SMMSRCPATH\n"
append SMM(vinfstr) "Tcl version: $tcl_version\n"
append SMM(vinfstr) "Tk version:  $tk_version\n"
append SMM(vinfstr) "\n"
append SMM(vinfstr) "Platform:\n"
append SMM(vinfstr) "Byteorder:   $tcl_platform(byteOrder)\n"
append SMM(vinfstr) "Machine:     $tcl_platform(machine)\n"
append SMM(vinfstr) "OS:          $tcl_platform(os)\n"
append SMM(vinfstr) "OS version:  $tcl_platform(osVersion)\n"
append SMM(vinfstr) "Platform:    $tcl_platform(platform)"

#----------------------------------------------------
loadmeter "Building mud manager."
TMudManager        mudm film

loadmeter "Building session manager."
TSesManager        sesm film mudm

#---------------------------------------------------
# create the image manager
loadmeter "Building image manager."
TImageManager imam [file join $SMMSRCPATH images]
loadmeter "Loading bg images (bw/ontop)."
imam  ddfLoad      bg_bw_ontop
loadmeter "Loading bg images (bw/below)."
imam  ddfLoad      bg_bw_below
loadmeter "Loading bg images (color/ontop)."
imam  ddfLoad      bg_color_ontop
loadmeter "Loading bg images (color/below)."
imam  ddfLoad      bg_color_below
loadmeter "Loading system images."
imam  ddfLoad      system
loadmeter "Loading stuff images 1."
imam  ddfLoad      stuff
loadmeter "Loading stuff images 2."
imam  ddfLoad      stuff_XL

#----------------------------------------------------
# TExitManager: defines some common look up behaviour
#  for all exits -> must be created just once
loadmeter "Building exit manager."
TExitManager ExitManager 32 imam

#----------------------------------------------------
# the error logger
loadmeter "Building Error Logger"
TErrorLogger .err
proc msgError {aStr} { .err msgError $aStr }
#----------------------------------------------------
# create the main UIF
loadmeter "Building main user interface."
TMainUif .smm guim film mudm sesm imam $SMM(vinfstr) $SMMMAPWINDOW .err

# at last load user color definitions
guim loadColorrc

#----------------------------------------------------

#.smmLoadmeter ready
wm withdraw .
destroy .smmstartupmsg





# ##############################################################################
# ### LOG MESSAGES
# ### As suggested by the CVS-manual this region is put to the end of the file.
# ##############################################################################
#
# $Log: startup.tcl,v $
# Revision 1.3  2002/05/10 07:33:20  issever
# changed version to 6.0.1
#
# Revision 1.2  2002/05/03 22:24:10  moth
# change version to 6.0
#
# Revision 1.1  2002/05/01 21:15:20  issever
# renamed smm.tcl into startup.tcl and placed it again into sources
#
# Revision 1.8  2002/04/06 23:16:24  issever
# smm.tcl should now start for iwidgets 3 and 4 without problems,..
# iwidgets 4 seems to need an additinal namespace import
#
# Revision 1.7  2002/04/06 16:59:18  moth
# Relaxed version requirement on Iwidgets, and explicitly import the itcl
# namespace, so that we can use Iwidgets 4.  Caution: as of now some dialogs
# seem to take a long time to pop up, and the close window event doesn't
# seem to be handled properly.
#
# Revision 1.6  2001/12/22 03:22:03  issever
# removed "option" setting for scrollbar width and buttonborder width
#
# Revision 1.5  2001/12/08 22:59:08  issever
# Session counter added.
#
# Revision 1.4  2001/12/07 23:48:38  issever
# Session and Mud Manager totally redone.
# They are now put into one window.
#
# Revision 1.3  2001/08/19 12:25:42  issever
# Added the cvs keywords Id at start of the file
# and Log at the end of the file
#
#
