#! /bin/sh
#
# smtp-gated	example file to build /etc/init.d/ scripts.
#		This file should be used to construct scripts for /etc/init.d.
#
#		Written by Miquel van Smoorenburg <miquels@cistron.nl>.
#		Modified for Debian 
#		by Ian Murdock <imurdock@gnu.ai.mit.edu>.
#
#		Further modified by Bartlomiej Korupczynski <bartek@klolik.org>
#		for use with smtp-gated
#

set -e

PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin
DAEMON=/usr/sbin/smtp-gated
NAME=smtp-gated
DESC=smtp-gated
SCRIPTNAME=/etc/init.d/$NAME
CONFIG=/etc/smtp-gated.conf
PIDFILE=`$DAEMON -t "$CONFIG" | awk '(/^pidfile/) {print $2}'`

# Gracefully exit if the package has been removed.
test -x $DAEMON || exit 0

# Include smtp-gated defaults if available
if [ -f /etc/default/smtp-gated ] ; then
	. /etc/default/smtp-gated
fi


case "$1" in
  start)
	echo -n "Starting $DESC: "
	start-stop-daemon --start --quiet --pidfile $PIDFILE \
		--exec $DAEMON -- "$CONFIG"
	echo "$NAME."
	;;
  stop)
	echo -n "Stopping $DESC: "
	start-stop-daemon --stop --quiet --pidfile $PIDFILE \
		--exec $DAEMON
	echo "$NAME."
	;;
  reload)
	#
	#	If the daemon can reload its config files on the fly
	#	for example by sending it SIGHUP, do it here.
	#
	#	If the daemon responds to changes in its config file
	#	directly anyway, make this a do-nothing entry.
	#
	# echo "Reloading $DESC configuration files."
	# start-stop-daemon --stop --signal 1 --quiet --pidfile \
	#	/var/run/$NAME.pid --exec $DAEMON

	echo -n "Syntax checking..."
	$DAEMON -t "$CONFIG" >/dev/null
	[ $? != 0 ] && echo " error. see syslog for details" && exit 1

	echo
	echo -n "Reloading $DESC configuration..."
	$DAEMON -r "$CONFIG"
	echo "."
  ;;
  restart|force-reload)
	#
	#	If the "reload" option is implemented, move the "force-reload"
	#	option to the "reload" entry above. If not, "force-reload" is
	#	just the same as "restart".
	#
	echo -n "Restarting $DESC: "
	$DAEMON -t "$CONFIG" >/dev/null || echo " config syntax error. see syslog for details" && exit 1
	kill `cat $PIDFILE`
	sleep 1

	start-stop-daemon --start --quiet --pidfile \
		/var/run/$NAME.pid --exec $DAEMON -- "$CONFIG"
	echo "$NAME."
	;;
  *)
	echo "Usage: $SCRIPTNAME {start|stop|restart|reload|force-reload}" >&2
	exit 1
	;;
esac

exit 0
