/*
 *	action.c
 *
 *	Copyright (C) 2004-2005 Bartomiej Korupczynski <bartek@klolik.org>
 *
 *	This program is free software; you can redistribute it and/or 
 *	modify it under the terms of the GNU General Public License 
 *	as published by the Free Software Foundation; either 
 *	version 2 of the License, or (at your option) any later 
 *	version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#define _GNU_SOURCE

/* public headers */
#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>


/* private headers */

#define _ACTION_C_
#include "smtp-gated.h"
#include "confvars.h"
#include "util.h"
#include "action.h"
#include "daemon.h"
#include "compat.h"


/*
 * 	zrob cos innego (TM) jesli znajdziemy wirusa :)
*/

/*
 * environment:
 *
 * FOUND: { SPAM | VIRUS | UNKNOWN }
 * VIRUS_NAME, SPAM_SCORE
 * SOURCE_IP, SOURCE_PORT
 * IDENT, IDENT_COUNT
 * TARGET_IP, TARGET_PORT
 * LOCAL_IP, LOCAL_PORT
 * MAIL_FROM, RCPTS_COUNT
 * SIZE, TRANSACTION
 * SPOOL_NAME
 * LOCK_FILE
 * TIME
 *
*/

void user_action(struct proc_data *data)
{
	int res, n;
	char *spam_score, *origin_port, *target_port;
	char *ident_count, *rcpts_total, *size, *transaction;
	char *time, *local_ip, *unixtime, *local_port;
	char *arg[8], *found;
	
	if (EMPTY_STRING(config.action_script)) return;

	if ((res = fork()) == -1) {
		log_action(LOG_CRIT, "user_action:fork failed: %s", strerror(errno));
		return;
	}

	// parent process
	if (res != 0) return;

	// child process
	if (data->server != -1) SAFE_CLOSE(data->server);
	SAFE_CLOSE(data->client);

	setsid();

	if (asprintf(&spam_score, "%f", data->spam_score) == -1) goto asprintf_err;
	if (asprintf(&origin_port, "%d", data->origin_port) == -1) goto asprintf_err;
	if (asprintf(&target_port, "%d", data->target_port) == -1) goto asprintf_err;
	if (asprintf(&local_port, "%d", config.port) == -1) goto asprintf_err;
	if (asprintf(&ident_count, "%d", data->ident_count) == -1) goto asprintf_err;
	if (asprintf(&rcpts_total, "%d", data->rcpts_total) == -1) goto asprintf_err;
	if (asprintf(&size, "%d", data->size) == -1) goto asprintf_err;
	if (asprintf(&transaction, "%d", data->transaction) == -1) goto asprintf_err;
	if (asprintf(&unixtime, "%" FORMAT_TIME_T, data->time) == -1) goto asprintf_err;

	time = time2str(data->time);
	local_ip = inet_ntoa(data->local_addr.sin_addr);
	switch (data->found) {
		case FOUND_VIRUS:
			found = "VIRUS";
			break;
		case FOUND_SPAM:
			found = "SPAM";
			break;
		case FOUND_MAX_HOST:
			found = "MAX_HOST";
			break;
		case FOUND_MAX_IDENT:
			found = "MAX_IDENT";
			break;
		default:
			found = "UNKNOWN";
	}

#ifdef HAVE_SETENV
	res = setenv("FOUND", found, 1);
	if (!res) res = setenv("PROXY_NAME", config.proxy_name, 1);
	if (!res) res = setenv("VIRUS_NAME", (!EMPTY_STRING(data->virus_name)) ? data->virus_name : "", 1);
	if (!res) res = setenv("SPAM_SCORE", spam_score, 1);
	if (!res) res = setenv("SOURCE_IP", data->origin_str, 1);
	if (!res) res = setenv("SOURCE_PORT", origin_port, 1);
	if (!res) res = setenv("TARGET_IP", data->target_str, 1);
	if (!res) res = setenv("TARGET_PORT", target_port, 1);
	if (!res) res = setenv("LOCAL_IP", local_ip, 1);
	if (!res) res = setenv("LOCAL_PORT", local_port, 1);
	if (!res) res = setenv("IDENT", (!EMPTY_STRING(data->ident)) ? data->ident : "", 1);
	if (!res) res = setenv("IDENT_COUNT", ident_count, 1);
	if (!res) res = setenv("MAIL_FROM", (!EMPTY_STRING(data->mail_from)) ? data->mail_from : "", 1);
	if (!res) res = setenv("RCPTS_TOTAL", rcpts_total, 1);
	if (!res) res = setenv("SIZE", size, 1);
	if (!res) res = setenv("TRANSACTION", transaction, 1);
	if (!res) res = setenv("SPOOL_NAME", (data->spool_exists) ? data->spool_name : "", 1);
	if (!res) res = setenv("LOCK_FILE", (!EMPTY_STRING(data->lockfile)) ? data->lockfile : "", 1);
	if (!res) res = setenv("TIME", time, 1);
	if (!res) res = setenv("UNIXTIME", unixtime, 1);

	if (res) {
		log_action(LOG_CRIT, "user_action: insufficient space in the environment");
		exit(5);
	}
#endif

	n = 0;	// !! n < argv[]
	arg[n++] = config.action_script;
	arg[n++] = found;
	arg[n++] = data->origin_str;
	arg[n++] = EMPTY_STRING(data->ident) ? "-" : data->ident;
	arg[n++] = data->target_str;
	arg[n++] = NULL;


	// no need to free allocated memory, as we are doing execv()
	if (foreground) log_action(LOG_DEBUG, "execv[%s]", config.action_script);
	res = execv(arg[0], arg);
	log_action(LOG_CRIT, "user_action:execv[%s] failed: %s", config.action_script, strerror(errno));
	exit(5);
asprintf_err:
	log_action(LOG_CRIT, "user_action:asprintf failed");
	exit(5);
} /* user_action() */




