/*
 * 	confvars.c
 *
 * 	Copyright (C) 2004-2005 Bartomiej Korupczynski <bartek@klolik.org>
 *
 * 	This program is free software; you can redistribute it and/or 
 * 	modify it under the terms of the GNU General Public License 
 * 	as published by the Free Software Foundation; either 
 * 	version 2 of the License, or (at your option) any later 
 * 	version.
 *
 * 	This program is distributed in the hope that it will be useful,
 * 	but WITHOUT ANY WARRANTY; without even the implied warranty of
 * 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * 	GNU General Public License for more details.
 *
 * 	You should have received a copy of the GNU General Public License
 * 	along with this program; if not, write to the Free Software
 * 	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>
#include <string.h>
#define SYSLOG_NAMES
#include <syslog.h>
#include "conffile.h"
#include "lang.h"
#include "smtp-gated.h"


struct option_enum oper_modes_list[] = {
	{ "none", MODE_NONE },
	{ "fixed", MODE_FIXED },
	{ "remote", MODE_REMOTE },
	{ "nat", MODE_NAT },
	{ NULL }
//	{ "tproxy", MODE_TPROXY }
};

struct option_enum facility_list[] = {
	{ "kern", LOG_KERN },
	{ "user", LOG_USER },
	{ "mail", LOG_MAIL },
	{ "daemon", LOG_DAEMON },
	{ "auth", LOG_AUTH },
	{ "lpr", LOG_LPR },
	{ "news", LOG_NEWS },
	{ "uucp", LOG_UUCP },
#ifdef LOG_AUDIT
	{ "audit", LOG_AUDIT },
#endif
	{ "cron", LOG_CRON },
#ifdef LOG_AUTHPRIV
	{ "authpriv", LOG_AUTHPRIV },
#endif
#ifdef LOG_FTP
	{ "ftp", LOG_FTP },
#endif
	{ "local0", LOG_LOCAL0 },
	{ "local1", LOG_LOCAL1 },
	{ "local2", LOG_LOCAL2 },
	{ "local3", LOG_LOCAL3 },
	{ "local4", LOG_LOCAL4 },
	{ "local5", LOG_LOCAL5 },
	{ "local6", LOG_LOCAL6 },
	{ "local7", LOG_LOCAL7 },
	{ NULL }
};

struct option_enum priority_list[] = {
	{ "alert", LOG_ALERT },
	{ "crit", LOG_CRIT },
	{ "debug", LOG_DEBUG },
	{ "emerg", LOG_EMERG },
	{ "err", LOG_ERR },
	{ "info", LOG_INFO },
	{ "notice", LOG_NOTICE },
	{ "warning", LOG_WARNING },
	{ NULL }
};


#define _CONFVARS_C 1
#include "confvars.h"

struct config_vars config;

#undef _CONFVARS_C
#define _CONFVARS_C 2

struct config_option opt[] = {
	#include "confvars.h"
	{ CONFIG_END }
};

struct config_option *config_options = opt;

#undef _CONFVARS_C
#define _CONFVARS_C 3

void confvars_init(struct config_vars *vars)
{
	#include "confvars.h"
}


