/*
 *  CONFIGURATION
*/

/*
	Defines proxy (host) name, used in banners
*/
CONF_OPT_STR(proxy_name, "smtp-proxy.isp")

/*
	Defined address and port to listen on
*/
CONF_OPT_IP(bind_address, "0.0.0.0")
CONF_OPT_PORT(port, 9199)

/*
	Defines source IP from which connection to destination
	server is made
*/
CONF_OPT_IP(source_addr, "0.0.0.0")

/*
	PID and state-dump files
	dumpfile_perm is octal value.
*/
CONF_OPT_STR(pidfile, "/var/run/smtp-gated/smtp-gated.pid")
CONF_OPT_STR(dumpfile, "/var/run/smtp-gated/state")
CONF_OPT_OCT(dumpfile_perm, 0660)

/*
	User name/UID and Group name/GID to switch to.
	Process priority.
	Chroot() path.
*/
CONF_OPT_STR_EMPTY(chroot_path, "")
CONF_OPT_STR_EMPTY(set_user, "")
CONF_OPT_STR_EMPTY(set_group, "")
CONF_OPT_INT(priority, 0)

/*
	Connect backlog, session buffer and pipeline size
*/
CONF_OPT_INT(connect_queue, 16)
CONF_OPT_UINT(buffer_size, 1516)
CONF_OPT_UINT(pipeline_size, 128)

/*
	Defines fixed IP and port for destination SMTP server
	(used if not empty, overrides netfilter and ident methods)
*/
CONF_OPT_IP_EMPTY(fixed_server, "")
CONF_OPT_PORT(fixed_server_port, 25)

/*
	Defines if local netfilter connectrack should be used for
	getting the IP of destination server.
	(overriden by fixed_server if set, overrides ident method)
*/
CONF_OPT_BOOL(use_netfilter, 0)
//CONF_OPT_ENUM(CONF_FLAG_NONE, mode, MODE_NONE, oper_modes_list)

/*
	Defined port to connect to remote ident w/ netfilter support
	(overriden by fixed_server and use_netfilter).
*/
CONF_OPT_PORT(lookup_port, 114)

/*
	Defined duration to reject client connections if a virus is detected
	0   no banning
	-1  ban forever
	Lock files go to lock_path directory. Lock files with UID=0 are
	considered as non-existent (and no further locking is done)
	lock_perm is octal value.
*/
CONF_OPT_INT(lock_duration, 0)
CONF_OPT_STR(lock_path, "/var/spool/smtp-gated/lock")
CONF_OPT_OCT(lock_perm, 0660)

/*
	Script called when SPAM/virus is found.

	All parameters are passed via environment variables.
	Script is run under new session (via setsid), and it's
	return value is ignored.
*/

CONF_OPT_STR_EMPTY(action_script, "")

/*
	Defines spool directory and permissions mask for new files
	as defined for open() function.
	spool_perm as octal value.
*/
CONF_OPT_STR(spool_path, "/var/spool/smtp-gated/msg")
CONF_OPT_OCT(spool_perm, 0666)

/*
	Some timeouts [s]
*/
// timeout sesji bezposredniej (np. po STARTTLS)
CONF_OPT_UINT(timeout_direct, 300)
// timeout identa
CONF_OPT_UINT(timeout_lookup, 10)
// timeout skanera antywirusowego + antyspamowego
CONF_OPT_UINT(timeout_scanner, 30)
// timeout skanera antyspamowego
CONF_OPT_UINT(timeout_spam, 30)
// timeout (symulowanej) sesji po przechwyceniu
CONF_OPT_UINT(timeout_session, 20)
// nic nie przychodzi, nic nie wychodzi
CONF_OPT_UINT(timeout_idle, 300)
// problemy z polaczeniem
CONF_OPT_UINT(timeout_connect, 30)


/*
	Maximum connections: all, per host and per ident
	max_connections requires RESTART to take effect
	max_per_*_lock: lock if max_per_* limit is exceeded
*/
CONF_OPT_UINT(max_connections, 64)
CONF_OPT_UINT(max_per_host, 8)
CONF_OPT_BOOL(max_per_host_lock, 0)
#ifdef USE_SHARED_MEM
CONF_OPT_UINT(max_per_ident, 4)
CONF_OPT_BOOL(max_per_ident_lock, 0)
#endif


/*
	Loadavg we should start rejecting connections
	(max_load <= 0 turns off this rejecting)
*/
CONF_OPT_DOUBLE(max_load, 10)

/*
	Maximum size of message to AV scan
*/
CONF_OPT_UINT(scan_max_size, 10000000)

/*
	antispam settings
	block spam if spam_block set, or just log scores if 0
	do not scan messages bigger than spam_max_size
	report message as spam if its score above spam_threshold
	skip antispam if loadavg > spam_max_load
	(spam_max_load <= 0 turns off this skipping)
*/
CONF_OPT_BOOL(spam_block, 0)
CONF_OPT_UINT(spam_max_size, 0)
CONF_OPT_DOUBLE(spam_max_load, 1)
CONF_OPT_DOUBLE(spam_threshold, 10)

/*
	Above this load fallback to direct proxy mode
	(no scanning, just pass all)
*/
//	CONF_OPT_DOUBLE(fallback_direct_load, 30)

/*
	Should we ignore errors and continue if possible?
	i.e. ignore scanner errors
*/
CONF_OPT_BOOL(ignore_errors, 0)

/*
	Leave spool (client message) on certain conditions
*/
CONF_OPT_BOOL(leave_on_error, 0)
CONF_OPT_BOOL(leave_on_virus, 0)
CONF_OPT_BOOL(leave_on_spam, 0)

/*
	Message sender/recipient logging mask
	0: do not log at all
	1: log only if MTA accepts it
	2: log only if MTA rejects it
	3: log always
*/
CONF_OPT_BOOL(log_helo, 0)
CONF_OPT_UINT(log_mail_from, 0)
CONF_OPT_UINT(log_rcpt_to, 0)

CONF_OPT_UINT(email_length, 64)

/*
	Debugging
	log_level: logging messages with level >= log_level
	default: 7 [DEBUG]
*/
CONF_OPT_ENUM(CONF_FLAG_NONE, log_level, LOG_DEBUG, priority_list)
CONF_OPT_ENUM(CONF_FLAG_NONE, log_facility, LOG_DAEMON, facility_list)

/*
	Defines if proxy header is injected into e-mails
	abuse is arbitrary string, i.e. e-mail abuse@isp
*/
CONF_OPT_STR(nat_header, "X-Nat-Received")
CONF_OPT_INT(nat_header_type, 0)
CONF_OPT_STR(spool_header, "X-Proxy-Spool-Info")
//CONF_OPT_INT(spool_header_type, 1)
CONF_OPT_STR_EMPTY(abuse, "")

/*
	Paths for scanners, scanner_path is for stand-alone scanner
*/
CONF_OPT_STR_EMPTY(scanner_path, "")
CONF_OPT_STR(clamd_path, "/var/run/clamav/clamd.ctl")
CONF_OPT_STR(spamd_path, "/var/run/spamd/spamd_socket")

#ifdef USE_PGSQL
/*
	PostgreSQL support variables
	NOT YET IMPLEMENTED
*/
CONF_OPT_STR_EMPTY(db_path, "")
CONF_OPT_STR_EMPTY(db_name, "")
CONF_OPT_STR_EMPTY(db_user, "")
CONF_OPT_STR_EMPTY(db_pass, "")
CONF_OPT_STR_EMPTY(db_condition, "SELECT 1 FROM found WHERE ident='%i' OR host='%h' AND when > now() - 7200 LIMIT 1")
CONF_OPT_STR_EMPTY(on_virus, "UPDATE")
CONF_OPT_STR_EMPTY(on_virus_2, "INSERT INTO found (what,name,ident,when) VALUES ('VIR','%v','%i',now()')")
CONF_OPT_STR_EMPTY(on_virus_notify, "")
CONF_OPT_STR_EMPTY(on_spam, "UPDATE")
CONF_OPT_STR_EMPTY(on_spam_2, "INSERT INTO found (what,name,ident,when) VALUES ('SPAM','%s','%i',now()')")
CONF_OPT_STR_EMPTY(on_spam_notify, "")
CONF_OPT_STR_EMPTY(on_host_flood, "")
CONF_OPT_STR_EMPTY(on_host_flood_2, "")
CONF_OPT_STR_EMPTY(on_host_flood_notify, "")
CONF_OPT_STR_EMPTY(on_ident_flood, "")
CONF_OPT_STR_EMPTY(on_ident_flood_2, "")
CONF_OPT_STR_EMPTY(on_ident_flood_notify, "")
#endif
/*
	Messages
*/
CONF_OPT_STR_EMPTY(locale, "")

CONF_OPT_STR_VERBOSE(msg_virus_found, MSG_VIRUS_FOUND)
CONF_OPT_STR_VERBOSE(msg_virus_no_more, MSG_VIRUS_NO_MORE)
CONF_OPT_STR_VERBOSE(msg_virus_locked, MSG_VIRUS_LOCKED)
CONF_OPT_STR_VERBOSE(msg_spam_found, MSG_SPAM_FOUND)
CONF_OPT_STR_VERBOSE(msg_unknown_virus, MSG_UNKNOWN_VIRUS)
CONF_OPT_STR_VERBOSE(msg_scanner_failed, MSG_SCANNER_FAILED)
CONF_OPT_STR_VERBOSE(msg_malformed_ip, MSG_MALFORMED_IP)
CONF_OPT_STR_VERBOSE(msg_cannot_connect, MSG_CANNOT_CONNECT)
CONF_OPT_STR_VERBOSE(msg_spool_problem, MSG_SPOOL_PROBLEM)
CONF_OPT_STR_VERBOSE(msg_spool_open_fail, MSG_SPOOL_OPEN_FAIL)
CONF_OPT_STR_VERBOSE(msg_pipeline_full, MSG_PIPELINE_FULL)
CONF_OPT_STR_VERBOSE(msg_lookup_failed, MSG_LOOKUP_FAILED)
CONF_OPT_STR_VERBOSE(msg_lookup_timeout, MSG_LOOKUP_TIMEOUT)
CONF_OPT_STR_VERBOSE(msg_lookup_mismatch, MSG_LOOKUP_MISMATCH)
CONF_OPT_STR_VERBOSE(msg_lookup_nomem, MSG_LOOKUP_NOMEM)
CONF_OPT_STR_VERBOSE(msg_connect_timeout, MSG_CONNECT_TIMEOUT)
CONF_OPT_STR_VERBOSE(msg_session_timeout, MSG_SESSION_TIMEOUT)
CONF_OPT_STR_VERBOSE(msg_sign_off, MSG_SIGN_OFF)
CONF_OPT_STR_VERBOSE(msg_hello, MSG_HELLO)
CONF_OPT_STR_VERBOSE(msg_proto_error, MSG_PROTO_ERROR)
CONF_OPT_STR_VERBOSE(msg_transaction_failed, MSG_TRANSACTION_FAILED)
CONF_OPT_STR_VERBOSE(msg_unimpl_command, MSG_UNIMPL_COMMAND)
CONF_OPT_STR_VERBOSE(msg_temp_unavail, MSG_TEMP_UNAVAIL)
CONF_OPT_STR_VERBOSE(msg_max_reached, MSG_MAX_REACHED)
CONF_OPT_STR_VERBOSE(msg_max_per_host, MSG_MAX_PER_HOST)
CONF_OPT_STR_VERBOSE(msg_max_per_ident, MSG_MAX_PER_IDENT)
CONF_OPT_STR_VERBOSE(msg_system_load, MSG_SYSTEM_LOAD)
CONF_OPT_STR_VERBOSE(msg_nomem, MSG_NOMEM)


