/*
 *	scan.h
 *
 *	Copyright (C) 2004-2005 Bartomiej Korupczynski <bartek@klolik.org>
 *
 *	This program is free software; you can redistribute it and/or 
 *	modify it under the terms of the GNU General Public License 
 *	as published by the Free Software Foundation; either 
 *	version 2 of the License, or (at your option) any later 
 *	version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _SCAN_H_
#define _SCAN_H_

#ifdef SCANNER_CLAMD
	#define SCANNER "clamd"
	#undef SCANNER_MKSD
	#undef SCANNER_MKS32
#else
	#ifdef SCANNER_MKSD
		#define SCANNER	"mksd"
		#include "libmksd.h"
		#undef SCANNER_MKS32
	#else
		#define SCANNER	"mks32"
		#define SCANNER_MKS32
	#endif
#endif

#ifndef _SCAN_C_
#define EXTERN extern
#else
#define EXTERN
#endif


/*
 *	scanning results
*/
typedef enum { SCAN_UNKNOWN = 0, SCAN_OK, SCAN_VIRUS, SCAN_FAILED, SCAN_TIMEOUT, SCAN_SKIPPED } av_result;
typedef enum { SPAM_UNKNOWN = 0, SPAM_OK, SPAM_NO, SPAM_YES, SPAM_FAILED, SPAM_TIMEOUT, SPAM_SKIPPED } spam_result;
typedef enum { SCAN_PASS = 0, SCAN_TAKEOVER } scan_result;



EXTERN av_result av_scanner(char *filename, char **result);
EXTERN spam_result spam_scanner(char *filename, double *score);



#undef EXTERN

#endif

