/*
 *	smtp-gated.h
 *
 *	Copyright (C) 2004-2005 Bartomiej Korupczynski <bartek@klolik.org>
 *
 *	This program is free software; you can redistribute it and/or 
 *	modify it under the terms of the GNU General Public License 
 *	as published by the Free Software Foundation; either 
 *	version 2 of the License, or (at your option) any later 
 *	version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef _SMTP_GATED_H_
#define _SMTP_GATED_H_

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <unistd.h>

#ifdef HAVE_ERR_H
#include <err.h>
#endif
#include <syslog.h>
#include <signal.h>

#ifndef _SMTP_GATED_C_
#define EXTERN extern
#else
#define EXTERN
#endif

/*
 *	hard configuration
*/

// don't change!!
#define RCPTS_ONE_TIME		2
#define SPAM_SCORE_NONE		-1000
#define PIPELINE_SIZE_MIN	16

/*
 *	ident results
*/

#define LOOKUP_OK		0x00
#define LOOKUP_TIMEOUT		0x01
#define LOOKUP_MISMATCH		0x02
#define LOOKUP_NOMEM		0x03


#define LOG_MAIL_ACCEPTED	0x01
#define LOG_MAIL_REJECTED	0x02
#define LOG_MAIL_BASE64		0x04


/*
 * 	macros
*/

#define SET_TIMEOUT(x)		timedout = 0; alarm(x);
#define CLEAR_TIMEOUT()		timedout = 0; alarm(0);

#ifndef VERSION
#error config.h not included
#endif

#ifdef USE_SHARED_MEM
#define SHARED_CONN_STATUS(x, y)	connections[child_slot].x = (y);
#define SHARED_STATS_INC(x) stats->x++;
#else
#define SHARED_CONN_STATUS(x, y)
#define SHARED_STATS_INC(x)
#endif




/*
 *	operational modes
*/

typedef enum {
	MODE_NONE = 0,
	MODE_FIXED,
	MODE_REMOTE,
	MODE_NAT,
	MODE_TPROXY
} oper_modes;

/*
 *	SMTP commands (~verbs)
*/

typedef enum {
	COMMAND_NONE = 0, COMMAND_OTHER,
	COMMAND_HELO, COMMAND_EHLO, COMMAND_RSET,	/*  2-4 */
	COMMAND_STARTTLS,				/* 5 */
	COMMAND_MAIL, COMMAND_RCPT,			/* 6-7 */
	COMMAND_DATA, COMMAND_DATA_ACK,			/* 8-9 */
	COMMAND_BDAT, COMMAND_QUIT			/* 10-11 */
} smtp_command;


/*
 *	SMTP DATA state
*/
typedef enum {
       GOING_NONE = 0, GOING_HEADER, GOING_BODY
} data_phase;

/*
 *	connections states (conn_states[] indesex)
*/
typedef enum {
       	CONN_START = 0, CONN_HELO,
	CONN_IDENT, CONN_CONNECT, CONN_PRE,
	CONN_DATA, CONN_BDAT, CONN_DIRECT,
	CONN_SCAN, CONN_SCAN1, CONN_SCAN2, CONN_SPAM, CONN_SPAM1, CONN_SPAM2,
	CONN_POST, CONN_RSET, CONN_QUIT
} conn_state;


/*
 *	found virus or found spam enum
*/
typedef enum {
	FOUND_NONE = 0, FOUND_VIRUS, FOUND_SPAM, FOUND_MAX_HOST, FOUND_MAX_IDENT
} found_what;

/*
 *	SMTP response struct
*/
struct response_code {
	int generic;		// 250
	int subject;		// 1
	int detail;		// 0
};


/*
 *	pipeline queue entry
*/
typedef uint pipeline_parm_t;

struct pipeline_entry {
	smtp_command cmd;
	pipeline_parm_t parm1;	/* BDAT bytes to go */
	pipeline_parm_t parm2;	/* BDAT LAST */
};


/*
 *	session data
*/
struct proc_data {
	// connections fd
	int client;			// (from) client socket
	int server;			// (to) server socket

	// connection data
	char ident[IDENT_SIZE+1];	// remote size ident string

	struct sockaddr_in origin;	// source (client/NAT) address
	char origin_str[16];		// source (client/NAT) IP text-address
	int origin_port;		// source (client/NAT) port
	
	struct sockaddr_in target;	// target (SMTP server) address
	char target_str[16];		// target (SMTP server) IP text-address
	int target_port;		// target (SMTP server) port

	struct sockaddr_in local_addr;	// source -> local address data
//	socklen_t local_addr_len;	// local_addr struct size
	
	// buffers
	char *cli_buf;			// bufor danych od klienta
	char *srv_buf;			// bufor danych z serwera
	int cli_size;			// ilosc danych w buforach
	int srv_size;
	
	int command_pos_client;		// queue position for client
	int command_pos_server;		// queue position for server
	struct pipeline_entry *pipeline;// command pipeline queue

	// nat header, to be injected to message
	char *header;			// nat header
	int header_size;		// nat header length

	// spooling data
	size_t size;			// spool size
	size_t extra_size;		// injected Spool-Info header size
	char *spool_name;		// spool file name
	int spool_fd;			// spool file descriptor || -1
	int spool_exists;		// spool file created && !deleted

	// lock file
	char *lockfile;			// lock filename

	// extension support
	int enhancedstatuscodes;	// ENHANCEDSTATUSCODES
	int chunking;			// CHUNKING

	// RFC 3030, BDAT n [LAST]
	// transaction_mode {NONE, DATA, BDAT}
	int data_used;			// DATA issued (per transaction)
	int bdat_used;			// BDAT issued (per transaction)
	int bdat_last;			// last chunk indicator [flag]
	int bdat_togo;			// bytes left to be read

	// DATA state
	data_phase data_going;		// DATA going

	// virus name
	char *virus_name;		// if found or NULL
	double spam_score;		// if spam found or SPAM_SCORE_NONE
	found_what found;		// what have we found in mail

	// recipients
	char *mail_from;		// pointer to mail from address
	int mail_from_logged;		// mail from was logged
	char *rcpt_to[RCPTS_ONE_TIME];	// pointers to mail recipients
	int rcpt_to_code[RCPTS_ONE_TIME];	// rcpt[i] is accept code by MTA
	int rcpts;			// recipients in buffer

	// statistics
	int cli_rx, srv_rx;		// statistics byte-counters
	int rcpts_total;		// recipients count for all transactions
	int transaction;		// SMTP transaction no.
	time_t time;			// start time

	// uzywana tylko przy USE_SHARED_MEM, ale jest w logach wiec zostaje
	int ident_count;		// count clients from this ident (not IP)

	// uzywane tylko przez wait_for_quit
	char *message;
	int command_count;
};


/*
 *	connection info (statistics)
*/
struct conn_info {
//	pid_t pid;
	uint32_t src;
	int start_time;

#ifdef USE_SHARED_MEM
	conn_state state;

	uint32_t dst;
	int cli_rx, srv_rx;
	int transaction;
	
	int ident_ok;
	char ident[IDENT_SIZE+1];
#endif
};


/*
 *	global statistics
*/
struct stat_info {
	time_t started;
	time_t restarted;

	int max_children;

	int requests;
	int rejects;
	int rejects_host;
	int rejects_lock;

	// shared_mem variables
	int rejects_ident;
	int viruses;
	int spams;
	int requests_direct;
	int requests_empty;
};



#ifndef _SMTP_GATED_C_
EXTERN volatile sig_atomic_t timedout;
EXTERN int i_am_a_child;
EXTERN struct stat_info *stats;
EXTERN struct conn_info *connections;
EXTERN char *conn_states[];
EXTERN int max_connections_real;
EXTERN pid_t *pids;
EXTERN int children;
EXTERN int child_slot;
#endif


EXTERN void log_action(int prio, char *format, ...)
	__attribute__ ((format (printf, 2, 3)));

EXTERN int fdprintf(int fd, char *format, ...)
	__attribute__ ((format (printf, 2, 3)));

EXTERN void set_dump_state(conn_state s);
	

#undef EXTERN

#endif


