/*
 * 	util.h
 *
 * 	Copyright (C) 2004-2005 Bartomiej Korupczynski <bartek@klolik.org>
 *
 * 	This program is free software; you can redistribute it and/or 
 * 	modify it under the terms of the GNU General Public License 
 * 	as published by the Free Software Foundation; either 
 * 	version 2 of the License, or (at your option) any later 
 * 	version.
 *
 * 	This program is distributed in the hope that it will be useful,
 * 	but WITHOUT ANY WARRANTY; without even the implied warranty of
 * 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * 	GNU General Public License for more details.
 *
 * 	You should have received a copy of the GNU General Public License
 * 	along with this program; if not, write to the Free Software
 * 	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef _UTIL_H_
#define _UTIL_H_

#include <stdlib.h>
#include <syslog.h>
#include <netinet/in.h>

#ifndef _UTIL_C_
#define EXTERN extern
#else
#define EXTERN
#endif


/*
 *	useful macros
*/

#define SIN_TO_UINT32(x)	(*((uint32_t *) &(x)))
#define UINT32_TO_SIN(x)	(*((struct in_addr *) &(x)))

#define TERMINATE_STRING(s) 	s[sizeof(s)-1] = '\0';
#define EMPTY_STRING(x) 	(x == NULL || x[0] == '\0')

#define FREE_NULL(x) 		if (x != NULL) { free(x); x = NULL; }

#define SAFE_CLOSE(x)		while (close(x) == -1 && errno == EINTR);

/*
 *	printf formats
*/

#if SIZEOF_PID_T == 8
#define FORMAT_PID_T "ld"
#else
#define FORMAT_PID_T "d"
#endif

#if SIZEOF_UID_T == 8
#define FORMAT_UID_T "ld"
#else
#define FORMAT_UID_T "d"
#endif

#if SIZEOF_TIME_T == 8
#define FORMAT_TIME_T "ld"
#else
#define FORMAT_TIME_T "ld"
#endif


/*
 *	log_action()
*/
#define LOG_ALWAYS		0x10

// "rozszerzenie" sysloga na potrzeby programu
// log_action() przycina priorytet komunikatow do
// LOG_DEBUG jesli sa wyzsze
#define LOG_VERBOSE		0x08


/*
 *	Connection status returned by fdgetline_cb() callbacks
*/
typedef enum {
	LINE_OK = 0, LINE_CLOSED, LINE_BINARY,				// ---- fdgetline_cb callback
	LINE_EINTR,							// ---- fdgetline_cb -------- EINTR=timeout
	LINE_CLOSED_SERVER, LINE_CLOSED_TIMEOUT, LINE_CLOSED_ADMIN,	// loop ------------ --------
	LINE_ERROR
} line_status;


typedef line_status (*line_callback)(char* buf, char* pos, int size, void *ptr);


EXTERN int connect_host(struct sockaddr_in dst, int dst_port, struct sockaddr_in src);
EXTERN int connect_path(char *path);
EXTERN int setup_listen(char *listen_ip, int listen_port, int backlog);

EXTERN void log_action(int prio, char* format, ...);
EXTERN int fdprintf(int fd, char* format, ...);
EXTERN line_status fdgetline_cb(int fd, char* buf, size_t sizeof_buf, int *buf_size,
	line_callback callback, void *ptr, int *rx_bytes);

EXTERN void untaint(/*@null@*/char *str, int len);
EXTERN void untaint_for_filename(/*@null@*/char *str, int len);
EXTERN int is_load_above(double max, double *current);

EXTERN char* time2str(time_t t);
EXTERN void time2dhms(int t, int *d, int *h, int *m, int *s);

EXTERN char* line_closed_cause(line_status st);

EXTERN char* alloc_msg_mail(char *line, int len);
EXTERN char* alloc_str_crlf(char *line, int len);

#ifdef USE_SHARED_MEM
EXTERN void* shmalloc(size_t size, int *id);
EXTERN int shmfreeid(int id);
#endif



#undef EXTERN

#endif

