#
# check if spam is blocked
#

use strict;
use vars qw(%set %conf %defs $prev);

#die "TODO\n";


# spam
$conf{'spam_max_size'} = 10000;
$conf{'spam_threshold'} = 5;
$conf{'spam_block'} = 1;
t_reload();

t_progress(1, 3);
t_smtp_init();
t_smtp_ehlo();

t_smtp_mail_rcpt();
t_smtp_one('DATA', '354 go ahead');
t_println_push('cli', t_gtube_body());

t_expect_flush('srv');
t_expect_closed('srv');

# no enhancedstatuscodes!
t_expect_regex('cli', '^550 [a-zA-Z]');
t_println('cli', 'QUIT');
t_expect_regex('cli', '^221 ');
t_expect_closed('cli');


# spam, just log, don't block
$conf{'spam_max_size'} = 10000;
$conf{'spam_block'} = 0;
t_reload();

t_progress(2, 3);
t_smtp_init();
t_smtp_ehlo();
t_smtp_mail_rcpt();
t_smtp_one('DATA', '354 go ahead');
t_println_push('cli', t_gtube_body());
t_expect_pop('srv');
t_println('srv', '250 Spool OK');
t_expect('cli', $prev);
t_smtp_quit();

# spam, don't even scan
$conf{'spam_max_size'} = 0;
$conf{'spam_block'} = 1;
t_reload();

t_progress(3, 3);
t_smtp_init();
t_smtp_ehlo();
t_smtp_mail_rcpt();
t_smtp_one('DATA', '354 go ahead');
t_println_push('cli', t_gtube_body());
t_expect_pop('srv');
t_println('srv', '250 Spool OK');
t_expect('cli', $prev);
t_smtp_quit();


1;

# : vim: syntax=perl :

