#
# check limit on total connections (max_connections)
#

use strict;
use vars qw(%set %conf %defs $prev);

my ($max, $over, $i);


$max = $conf{'max_connections'};
$over = $max+1;

# some OS don't allow to bind to 127.0.0.x other than 127.0.0.1
unless ($set{'alt_ip_ok'}) {
	t_debug('no alternate IP available - test skipped');
	die "N/A\n";
}
# max_connections can NOT be changed without full restart
#die "conf{max_connections} not set to 4!\n" if ($max != 4);

$conf{'max_per_host'} = $max + 10;
t_reload();

for ($i=1; $i<=$max; $i++) {
	t_smtp_init("cli-$i", "srv-$i", "127.0.0.$i");
	t_smtp_helo();
}

t_connect('cli-x', "127.0.0.$over");
t_expect_regex('cli-x', '^554 ');
t_expect_closed('cli-x');


for ($i=1; $i<=$max; $i++) {
	t_change("cli-$i", "srv-$i");
	t_smtp_send();
	t_smtp_quit();
}


1;

# : vim: syntax=perl :

