#
# check limit per host connections (max_per_host)
#

use strict;
use vars qw(%set %conf %defs $prev);

# some OS don't allow to bind to 127.0.0.x other than 127.0.0.1
unless ($set{'alt_ip_ok'}) {
	t_debug('no alternate IP available - test skipped');
	die "N/A\n";
}

# max_connections can NOT be changed without full restart
die "conf{max_connections} less than 4!\n" if ($conf{'max_connections'} < 4);

$conf{'max_per_host'} = 1;
t_reload();


t_smtp_init('cli-1a', 'srv-1a', $set{'src_ip'});
t_smtp_ehlo();

t_smtp_init('cli-2', 'srv-2', $set{'src_ip_alt'});
t_smtp_ehlo();

#
# these should fail
t_connect('cli-1b', '127.0.0.1');
t_expect_regex('cli-1b', '^554 ');
t_expect_closed('cli-1b');

t_connect('cli-1c', '127.0.0.1');
t_expect_regex('cli-1c', '^554 ');
t_expect_closed('cli-1c');

t_connect('cli-1d', '127.0.0.1');
t_connect('cli-1e', '127.0.0.1');
t_expect_regex('cli-1d', '^554 ');
t_expect_regex('cli-1e', '^554 ');
t_expect_closed('cli-1d');
t_expect_closed('cli-1e');

# cli-2/srv-2
t_smtp_mail_rcpt();
t_smtp_send();
t_smtp_quit();

t_change('cli-1a', 'srv-1a');
t_smtp_mail_rcpt();
t_smtp_send();
t_smtp_quit();


1;

# : vim: syntax=perl :

