#
# check for proper message size limit
#

use strict;
use vars qw(%set %conf %defs $prev);


# 1. eicar
# 2. max_scan_size = 2, reload
# 3. eicar

t_reload();
t_smtp_init();
t_smtp_ehlo();

t_smtp_mail_rcpt();
t_smtp_one('DATA', '354 go ahead');
t_println_push('cli', t_eicar_body());

t_expect_flush('srv');
t_expect_closed('srv');

t_expect_regex('cli', '^550 [a-zA-Z]');
t_println('cli', 'QUIT');
t_expect_regex('cli', '^221 ');
t_expect_closed('cli');

#
# now eicar should pass
#

$conf{'scan_max_size'} = 5;
t_reload();
t_smtp_init();
t_smtp_ehlo();

t_debug("1");
t_smtp_mail_rcpt();
t_smtp_one('DATA', '354 go ahead');
t_println_push('cli', t_eicar_body());

t_expect_pop('srv');

t_println('srv', '250 Spool OK');
t_expect('cli', $prev);

t_smtp_quit();


1;

# : vim: syntax=perl :


