#
# STARTTLS & direct proxy test
#

use strict;
use vars qw(%set %conf %defs $prev);


t_reload();

# STARTTLS
t_smtp_init();
t_smtp_ehlo();
t_smtp_one('STARTTLS', '220 OK');

# this won't be av-checked, so should pass intact
t_smtp_ehlo();
t_smtp_mail_rcpt();
t_smtp_one('DATA', '354 go ahead');
t_println_push('cli', t_eicar_body());
t_expect_pop('srv');

t_println('srv', '250 Spool OK');
t_expect('cli', $prev);
t_smtp_quit();


# STARTTLS rejected
t_smtp_init();
t_smtp_ehlo();
t_smtp_one('STARTTLS', '454 TLS not available due to temporary reason');

t_smtp_mail_rcpt();
t_smtp_one('DATA', '354 go ahead');
t_println_push('cli', t_eicar_body());

t_expect_flush('srv');
t_expect_closed('srv');

t_expect_regex('cli', '^550 [a-zA-Z]');
t_println('cli', 'QUIT');
t_expect_regex('cli', '^221 ');
t_expect_closed('cli');


1;

# : vim: syntax=perl :
