#
# check if unsupported extensions are filtered properly
#

use strict;
use vars qw(%set %conf %defs $prev);


if ($defs{'FILTER_CHUNKING'} ne 'yes') {
	t_debug('FILTER_CHUNKING not defined during compilation - test skipped');
	die "N/A\n"
}


t_reload();

t_connect('cli');
t_accept('srv');

t_println('srv', '220 fake MTA says hello (so be prepared)');
t_expect('cli', $prev);

t_println('cli', 'EHLO fake.MUA');
t_expect('srv', $prev);
t_println_push('srv',
	'250-fake MTA greets fake.MUA (be still prepared)',
	'250-SIZE 10000000',
	'250-X-RCPTLIMIT 10000',
	'250-PIPELINING',
	'250-ENHANCEDSTATUSCODES',
	'250-DSN',
	'250-AUTH=LOGIN',
	'250-AUHT LOGIN',
	'250-STARTTLS',
	'250-8BITMIME',
	'250-HELP'
);
t_expect_pop('cli');

#
# these should be filtered
#

t_println('srv', '250-BINARYMIME');
t_println('srv', '250-CHUNKING');
t_println('srv', '250 XEXCH50');

t_expect('cli', "250-BIN*RYMIME\r\n");
t_expect('cli', "250-CHU*KING\r\n");
t_expect('cli', "250 XEX*H50\r\n");

t_println('cli', 'MAIL FROM: <bartek@test.test>');
t_expect('srv', $prev);
t_println('cli', 'RCPT TO: <bartek@test.test>');
t_expect('srv', $prev);

#
# BDAT with no parameters is not filtered
t_println('cli', 'BDAT');
t_expect('srv', $prev);

#
# BDAT filtered
t_println('cli', 'BDAT 4000');
t_expect('srv', "BDA* 4000\r\n");
t_println('cli', 'BDAT 4000 LAST');
t_expect('srv', "BDA* 4000 LAST\r\n");

#
# XEXCH50 with no parameters is not filtered
t_println('cli', 'XEXCH50');
t_expect('srv', $prev);

#
# XEXCH50 filtered
t_println('cli', 'XEXCH50 4000');
t_expect('srv', "XEX*H50 4000\r\n");

#
# just check one more not within proper session state
t_smtp_one('RSET', '250 OK');
t_println('cli', 'BDAT 4000 LAST');
t_expect('srv', "BDA* 4000 LAST\r\n");

#
# now check for normal transaction
t_smtp_send();
t_smtp_quit();


1;

# : vim: syntax=perl :

