#
# check if locking works
# does not check real lock-duration
#

use strict;
use vars qw(%set %conf %defs $prev);

$conf{'lock_duration'} = 60;

# remove any previuos left locks
unlink($set{'lock'});

t_reload();

# 1. clean mail
t_progress(1, 4);
t_smtp_init();
t_smtp_ehlo();
t_smtp_send();
t_smtp_quit();

# 2. infected mail
t_progress(2, 4);
t_smtp_init();
t_smtp_ehlo();
t_smtp_mail_rcpt();
t_smtp_one('DATA', '354 go ahead');
t_println_push('cli', t_eicar_body());
t_expect_flush('srv');
t_expect_closed('srv');
t_expect_regex('cli', '^550 [a-zA-Z]');
t_println('cli', 'QUIT');
t_expect_regex('cli', '^221 ');
t_expect_closed('cli');

# 3. reject all
t_progress(3, 4);
t_connect('cli');
t_expect_regex('cli', '^554 .*');
t_expect_closed('cli');

# 4. reject many
t_progress(4, 4);
t_connect('cli-1');
t_connect('cli-2');
t_connect('cli-3');
t_expect_regex('cli-1', '^554 .*');
t_expect_regex('cli-2', '^554 .*');
t_expect_regex('cli-3', '^554 .*');
t_expect_closed('cli-1');
t_expect_closed('cli-2');
t_expect_closed('cli-3');

# remove existing lock
unlink($set{'lock'});


1;

# : vim: syntax=perl :
