#
# check if locking expiration works
#

use strict;
use vars qw(%set %conf %defs $prev);


$conf{'lock_duration'} = 60;

# remove possibly left lock
unlink($set{'lock'});

t_reload();

# 1. clean mail
t_progress(1, 5);
t_smtp_init();
t_smtp_ehlo();
t_smtp_send();
t_smtp_quit();

# 2. infected mail
t_progress(2, 5);
t_smtp_init();
t_smtp_ehlo();
t_smtp_mail_rcpt();
t_smtp_one('DATA', '354 go ahead');
t_println_push('cli', t_eicar_body());
t_expect_flush('srv');
t_expect_closed('srv');
t_expect_regex('cli', '^550 [a-zA-Z]');
t_println('cli', 'QUIT');
t_expect_regex('cli', '^221 ');
t_expect_closed('cli');

# 3. reject
t_progress(3, 5);
t_connect('cli');
t_expect_regex('cli', '^554 .*');
t_expect_closed('cli');

# 4. reject after simple reload
t_progress(4, 5);
t_reload();
t_connect('cli');
t_expect_regex('cli', '^554 .*');
t_expect_closed('cli');

# 5. lock "expired"
t_progress(5, 5);
$conf{'lock_duration'} = 1;
t_reload();
sleep(1);

t_smtp_init();
t_smtp_ehlo();
t_smtp_send();
t_smtp_quit();

# remove existing lock
unlink($set{'lock'});

#my $max=1000;
#for (my $i=1; $i<$max; $i++) {
#	t_progress($i, $max);
#	t_reload();
#}

1;

# : vim: syntax=perl :
