#
# check if script is called when virus found
#

use strict;
use vars qw(%set %conf %defs $prev $path);

die "N/A\n" if $defs{'HAVE_SETENV'} eq 'no';


my $score = 5;
my $max_utime_diff = 10;
my $action_sleep = 0;
my $action_log = "$set{path_log}/action.log";
my $action_dat = "$set{path_log}/action.dat";
$conf{'action_script'} = "$set{path}/action.sh";
$conf{'log_mail_from'} = 3;
$conf{'spam_max_size'} = 10000;
$conf{'spam_threshold'} = $score;
$conf{'spam_block'} = 1;


#
# save our pid for scripting purpose
open(AP, ">$action_dat") || die "can't write action_dat [$action_dat]: $!\n";
printf AP "ACTION_PID=%s\n", getpid();
printf AP "ACTION_SLEEP=%s\n", $action_sleep;
printf AP "ACTION_LOG=%s\n", $action_log;
close(AP);

unlink $action_log;

#
# start
t_reload();

t_smtp_init();
t_smtp_helo();
t_smtp_send();

t_smtp_one('RSET', '250 OK');

t_println_push('cli',
	'MAIL FROM: <bartek@test.test>',
	'RCPT TO: <bartek@test.test>',
	'RCPT TO: <bartek@test.test>',
	'RCPT TO: <bartek@test.test>',
	'RCPT TO: <bartek@test.test>',
	'RCPT TO: <bartek@test.test>'
);
t_expect_pop('srv');
t_println_push('srv', '250 OK') for (1..6);
t_expect_pop('cli');
t_smtp_one('DATA', '354 go ahead');


# wait while script ends
# moze zamiast sleep() otworzyc jakis socket, zeby
# skrypt do niego napisal?
eval {
	local $SIG{'HUP'} = sub { die "OK\n"; };
	t_println_push('cli', t_gtube_body($score));
	sleep($set{'timeout'});
};
die "Not signalled -- script failed to complete.\n" unless ($@ eq "OK\n");

t_expect_flush('srv');
t_expect_closed('srv');
t_expect_regex('cli', '^550 [a-zA-Z]');
t_println('cli', 'QUIT');
t_expect_regex('cli', '^221 ');
t_expect_closed('cli');

# TIME=Fri Sep 16 17:46:32 2005
# PROXY_NAME=$conf{'proxy_name'}
# UNIXTIME=1126885592
# FOUND=SPAM
# VIRUS_NAME=
# SPAM_SCORE=10.000000
# SOURCE_IP=127.0.0.1
# SOURCE_PORT=37699
# TARGET_IP=127.0.0.1
# TARGET_PORT=2111
# LOCAL_IP=127.0.0.1
# LOCAL_PORT=2121
# IDENT=
# IDENT_COUNT=0
# MAIL_FROM=bartek@test.test
# RCPTS_TOTAL=6
# SIZE=295
# TRANSACTION=2
# SPOOL_NAME=/home/bartek/prog/c/smtp-gated/tests/msg/1126885592.9488
# LOCK_FILE=/home/bartek/prog/c/smtp-gated/tests/lock/127.0.0.1

my %al;
open(ACTION_LOG, $action_log) || die "can't open action log [$action_log]: $!\n";
while (defined($_=<ACTION_LOG>)) {
	chomp;
	my ($key, $val) = split /=/, $_, 2;
	$al{$key} = $val;
}
close(ACTION_LOG);

die "invalid PROXY_NAME!\n" unless ($al{'PROXY_NAME'} eq $conf{'proxy_name'});
die "invalid UNIXTIME!\n" unless ($al{'UNIXTIME'} =~ m%^[0-9]+$%);
die "UNIXTIME out of range!\n" unless ($al{'UNIXTIME'} - time() <= $max_utime_diff);
die "invalid TIME!\n" unless ($al{'TIME'} eq localtime($al{'UNIXTIME'}));
die "invalid FOUND!\n" unless ($al{'FOUND'} eq 'SPAM');
die "invalid VIRUS_NAME!\n" unless ($al{'VIRUS_NAME'} eq '');
die "invalid SPAM_SCORE!\n" unless ($al{'SPAM_SCORE'} eq "$score.000000");
die "invalid SOURCE_IP!\n" unless ($al{'SOURCE_IP'} eq '127.0.0.1');
die "invalid TARGET_IP!\n" unless ($al{'TARGET_IP'} eq '127.0.0.1');
die "invalid LOCAL_IP!\n" unless ($al{'LOCAL_IP'} eq '127.0.0.1');
die "invalid SOURCE_PORT!\n" unless ($al{'SOURCE_PORT'} =~ m%^[0-9]+$%);
die "invalid TARGET_PORT!\n" unless ($al{'TARGET_PORT'} eq $conf{'fixed_server_port'});
die "invalid LOCAL_PORT!\n" unless ($al{'LOCAL_PORT'} eq $conf{'port'});

die "invalid IDENT!\n" unless ($al{'IDENT'} eq '');
die "invalid IDENT_COUNT!\n" unless ($al{'IDENT_COUNT'} eq '0');
die "invalid MAIL_FROM!\n" unless ($al{'MAIL_FROM'} eq 'bartek@test.test');
die "invalid RCPTS_TOTAL!\n" unless ($al{'RCPTS_TOTAL'} eq '6');
die "invalid SIZE!\n" unless ($al{'SIZE'} =~ /^[0-9]+$/);
die "invalid TRANSACTION!\n" unless ($al{'TRANSACTION'} eq '2');
die "invalid SPOOL_NAME!\n" unless ($al{'SPOOL_NAME'} =~ m%^$conf{spool_path}/$al{UNIXTIME}\.[0-9]+$%);
die "invalid LOCK_FILE!\n" unless ($al{'LOCK_FILE'} eq $set{'lock'});


#unlink $action_log;
unlink $action_dat;

1;

# : vim: syntax=perl :
