#
# mass send/lock/etc
#

use strict;
use vars qw(%set %conf %defs $prev);

my $max = 20000;
my $rej_code = $defs{'CONN_REJ_CODE'};

die "LONG\n" unless $set{'long'} or $max <= 500;

$conf{'lock_duration'} = 7200;


t_reload();

# issue lock
t_smtp_init();
t_smtp_ehlo();

t_smtp_mail_rcpt();
t_smtp_one('DATA', '354 go ahead');
t_println_push('cli', t_eicar_body());

t_expect_flush('srv');
t_expect_closed('srv');

# no enhancedstatuscodes!
t_expect_regex('cli', '^550 [a-zA-Z]');
t_println('cli', 'QUIT');
t_expect_regex('cli', '^221 ');
t_expect_closed('cli');

# test many locked connections
for(my $i=1; $i<=$max; $i++) {
	t_progress($i, $max);

	eval {
		local $SIG{'USR1'} = sub { die "OK\n"; };
		t_connect('cli');
		t_expect_regex('cli', "^$rej_code ");
		t_expect_closed('cli');
		sleep($set{'process_timeout'});
	};

	die $@ if ($@ ne "OK\n");
}


1;

# : vim: set syntax=perl :
