/* -*- c++ -*- */
/***************************************************************************
                          levelobject.h  -  description
                             -------------------
    begin                : thu sept 19 21:19:00 CET 2002
    copyright            : (C) 2002 by Romain Vinot
    email                : vinot@aist.enst.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _LEVELOBJECT_H_
#define _LEVELOBJECT_H_

#include <list>
#include <qdom.h>
#include <set>

#define NbLvlObjectType 16

#include "creature.h"

class Board;
class GUICommandLine;

using namespace std;
class Level;

typedef enum
  {
    OT_NONE        = 0,
    OT_TERMINATOR  = 1 <<  0,
    OT_FLAMER      = 1 <<  1,
    OT_SERGEANT    = 1 <<  2,
    OT_SQUAD       = 1 <<  3,
    OT_GENESTEALER = 1 <<  4,
    OT_BLIP        = 1 <<  5,
    OT_CAT         = 1 <<  6,
    OT_FLOOR       = 1 <<  7,
    OT_DOOR        = 1 <<  8,
    OT_BULKHEAD    = 1 <<  9,
    OT_ENTRY       = 1 << 10,
    OT_EXIT        = 1 << 11,
    OT_EXTENSIBLE  = 1 << 12,
    OT_ZONE        = 1 << 13,
    OT_ZONELIST    = 1 << 14,
    OT_VALUE       = 1 << 15,
    OT_CREATURE    = (OT_TERMINATOR|OT_FLAMER|OT_SERGEANT|OT_SQUAD|
		      OT_GENESTEALER|OT_BLIP),
    OT_ALIEN       = (OT_GENESTEALER|OT_BLIP),
    OT_MARINE      = (OT_TERMINATOR|OT_FLAMER|OT_SERGEANT|OT_SQUAD),
    OT_UNIT        = (OT_ALIEN|OT_MARINE)
  } LvlObjectType;

class LevelObject
{
public:
  //virtual void Build(const QDomElement& e, Level *l);
  LevelObject();
  virtual ~LevelObject() {};
  virtual QString getDesc() = 0;
  bool is_ref;
  GUICreature *guiCreature;
  GUICommandLine *guiCmdLine;
  Level *level;
  static LvlObjectType Name2LvlType(QString name);
  static QString LvlType2Name(LvlObjectType object);
  static LvlObjectType Type2LvlType(ObjectType type);
  static ObjectType LvlType2Type(LvlObjectType type);
  LvlObjectType Type();
protected:
  LvlObjectType type;
};

class LvlValue : public LevelObject
{
public:
  LvlValue();
  LvlValue(int v);
  int value;
};

class Point
{
public:
  Point() {x = 0; y = 0;};
  Point(int px, int py) {x = px; y = py;};
  int x,y;
};

ostream& operator<<(ostream& s, const Point& p);

struct PtComp
{
  bool operator()(const Point& p1, const Point& p2) const
  {
    if(p1.y < p2.y)
      {
	return true;
      }
    if(p1.y > p2.y)
      {
	return false;
      }
    if(p1.x < p2.x)
      {
	return true;
      }
    return false;
  };
};

// Classes for Zone and ZoneList
class LvlZone : public LevelObject
{
public:
  LvlZone();
  static LvlZone* Build(const QDomElement& e, Level *l);
  set<int> cases;
  virtual QString getDesc();
  set<int>* getCases();
  bool contains(int Position);
};

class LvlZoneList : public LevelObject
{
public:
  LvlZoneList();
  static LvlZoneList* Build(const QDomElement& e, Level *l);
  list<LvlZone*> zone_list;
  virtual QString getDesc();
  set<int>* getCases();
  LvlZone* containing(int Position);
};

class LvlUserPutObject : public virtual LevelObject
{
public:
  LvlUserPutObject();
  virtual Object* CreateObject() = 0;
  virtual QString PlaceUnit() = 0;
  virtual void getParameters(set<int> *cases);
  int position;
  Direction dir;
  Object *unit;
};

// Unit classes
class LvlUnit : public LvlUserPutObject
{
public:
  static LvlUnit* ConvertUnit(Object *obj, Level *l);
  LvlUnit();
  int getActPts();
  bool hasAnObject();
};

class LvlSquad : public LvlUnit
{
public:
  LvlSquad();
  static LvlSquad* Build(const QDomElement& e, Level *l);
  virtual Object* CreateObject() {return NULL;};
  virtual QString getDesc();
  virtual QString PlaceUnit() {return "";};
  list<LvlUserPutObject*> members;
  QString name;
};

class LvlAlien : public LvlUnit
{
};

class LvlBlip : public LvlAlien
{
public:
  LvlBlip();
  static LvlBlip* Build(const QDomElement& e, Level *l);
  static LvlBlip* Build(Blip *obj, Level *l);
  virtual Object* CreateObject();
  virtual void getParameters(set<int> *cases);
  bool wait;
  virtual QString getDesc();
  virtual QString PlaceUnit();
  int nbGen;
};

class LvlGenestealer : public LvlAlien
{
public:
  LvlGenestealer();
  static LvlGenestealer* Build(const QDomElement& e, Level *l);
  static LvlGenestealer* Build(Genestealer *obj, Level *l);
  virtual Object* CreateObject();
  virtual QString PlaceUnit();
  virtual QString getDesc();
};

class LvlMarine : public LvlUnit
{
};

class LvlBolter : public LvlMarine
{
public:
  LvlBolter();
  static LvlBolter* Build(const QDomElement& e, Level *l);
  static LvlBolter* Build(BolterMarine *obj, Level *l);
  virtual QString getDesc();
  virtual QString PlaceUnit();
  virtual Object* CreateObject();
};

class LvlFlamer : public LvlMarine
{
public:
  LvlFlamer();
  static LvlFlamer* Build(const QDomElement& e, Level *l);
  static LvlFlamer* Build(FlamerMarine *obj, Level *l);
  int charger;
  virtual Object* CreateObject();
  virtual QString PlaceUnit();
  virtual QString getDesc();
};

class LvlSergeant : public LvlMarine
{
public:
  LvlSergeant();
  static LvlSergeant* Build(const QDomElement& e, Level *l);
  static LvlSergeant* Build(Sergeant *obj, Level *l);
  virtual QString getDesc();
  virtual QString PlaceUnit();
  virtual Object* CreateObject();
  Sergeant *sergeant;
};

class LvlCAT : public LvlUnit
{
public:
  LvlCAT();
  static LvlCAT* Build(const QDomElement& e, Level *l);
  static LvlCAT* Build(ModuleCAT *obj, Level *l);
  virtual void getParameters(set<int> *cases);
  virtual QString getDesc();
  virtual QString PlaceUnit();
  virtual Object* CreateObject();
};

// Map objects classes

class LvlMapObject : public virtual LevelObject
{
public:
  virtual void ApplyOnBoard();
  virtual ~LvlMapObject();
  virtual QString getDesc();
protected:
  Object* object;
  LvlZone* zone;
};

class LvlFloor : public LvlMapObject
{
public:
  LvlFloor();
  static LvlFloor* Build(const QDomElement& e, Level *l);
  virtual void ApplyOnBoard();
};

class LvlDoor : public LvlMapObject
{
public:
  LvlDoor();
  static LvlDoor* Build(const QDomElement& e, Level *l);
  static LvlDoor* Build(Door* d, Level *l);
};

class LvlBulkhead : public LvlMapObject
{
public:
  LvlBulkhead();
  static LvlBulkhead* Build(const QDomElement& e, Level *l);
};

class LvlEntry : public LvlMapObject
{
public:
  LvlEntry();
  static LvlEntry* Build(const QDomElement& e, Level *l);
};

class LvlExit : public LvlMapObject
{
public:
  LvlExit();
  static LvlExit* Build(const QDomElement& e, Level *l);
};

class LvlExtensible : public LvlMapObject, public LvlUserPutObject
{
public:
  LvlExtensible();
  static LvlExtensible* Build(const QDomElement& e,Level *l,bool isUnit=false);
  virtual Object* CreateObject();
  virtual QString PlaceUnit();
  virtual void getParameters(set<int> *cases);
  virtual QString getDesc();
};

// A reference in the level description
class LevelRef
{
public:
  typedef list<LevelObject*>::iterator iterator;
  LevelRef(LvlObjectType type, QString name);
  LevelRef(LvlObjectType type, LevelObject *object, QString name);
  LevelRef(LvlBlip *object, QString name);
  LevelRef(LvlGenestealer *object, QString name);
  LevelRef(LvlBolter *object, QString name);
  LevelRef(LvlSergeant *object, QString name);
  LevelRef(LvlFlamer *object, QString name);
  LevelRef(LvlCAT *object, QString name);
  LevelRef(LvlEntry *object, QString name);
  LevelRef(LvlDoor *object, QString name);
  LevelRef(LvlBulkhead *object, QString name);
  LevelRef(LvlExit *object, QString name);
  LevelRef(LvlExtensible *object, QString name);
  LevelRef(LvlZone *object, QString name);
  LevelRef(LvlZoneList *object, QString name);
  LevelRef(LvlSquad *object, QString name);
  LevelRef(LvlValue *object, QString name);
  LevelObject& operator*();
  const QString& getName();
  LvlObjectType getType();
  ~LevelRef();
  iterator begin();
  iterator end();
  int size();
  void AddObject(LvlObjectType type, LevelObject *object);
  void AddObject(LvlBlip *object);
  void AddObject(LvlGenestealer *object);
  void AddObject(LvlBolter *object);
  void AddObject(LvlSergeant *object);
  void AddObject(LvlFlamer *object);
  void AddObject(LvlCAT *object);
  void AddObject(LvlEntry *object);
  void AddObject(LvlDoor *object);
  void AddObject(LvlBulkhead *object);
  void AddObject(LvlExit *object);
  void AddObject(LvlExtensible *object);
  void AddObject(LvlZone *object);
  void AddObject(LvlZoneList *object);
  void AddObject(LvlSquad *object);
  void AddObject(LvlValue *object);

protected:
  list<LevelObject*> objects;
  LvlObjectType type;
  QString name;
};

/******************************
 * Definition of the template *
 ******************************/

#endif
