/***************************************************************************
                          sendmail.cpp  -  description
                             -------------------
    begin                : dim may 15 16:56:00 CET 2003
    copyright            : (C) 2002 by Romain Vinot
    email                : vinot@aist.enst.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef _WIN32
#pragma warning (disable : 4786)
#endif

#include <cstring>
#include <cstdio>
#include <qstring.h>

#include "mailservice.h"

#include "smtp.h"

#define BASE64(a) (((a)<=25)?((a)+'A'):\
		   ((a)<=51)?((a)-26+'a'):\
		    ((a)<=61)?((a)-52+'0'):\
		     (((a)==62)?('+'):(((a)==63)?('/'):('='))))

Mail::Mail (QString &f, QString &t)
  : msg(""), from(f), to(t)
{}

Mail::~Mail() {}

void Mail::createMail(char *attach, int len, QString &filename, 
		      QString &playermsg)
{
  msg += "From: " + from + "\r\n";
  msg += "To: " + to + "\r\n";
  msg += "Subject: [QSpaceHulk] PBEM ...\r\n";
  msg += "MIME-Version: 1.0\r\n";
  msg += "Content-Type: multipart/mixed;         boundary=\"__boundary\"\r\n";
  
  // First part of the body.
  msg += "\r\nThis is a multi-part message in MIME format.\r\n\r\n";
  msg += "--__boundary\r\n";
  msg += "Content-Type: text/plain\r\n\r\n";
  msg += "QSpaceHulk pbem save file is on attachment of this file.\r\n";
  if (!playermsg.isEmpty()) {
    // player message fix for *nix clients sending via qmail servers
    // This fixes the error message that reports http://cr.yp.to/docs/smtplf.html
    // In theory...  - gold@magick.com.au
    playermsg.replace("\r\n", "\n"); // Sanity check
    playermsg.replace("\n", "\r\n"); // Fix \n's for qmail servers (and probably others...)
    msg+= playermsg + "\r\n";
  }
  msg += "\r\n";
  
  // Second part of the body : the attachent file.
  msg += "--__boundary\r\n";
  msg += "Content-Type: application/octet-stream;\r\n  name=\"" + filename + "\"\r\n";
  msg += "Content-Transfer-Encoding: base64\r\n";
  msg += "Content-Disposition: attachment;    filename=\"" + filename + "\"\r\n\r\n";
  base64Encode(attach, len);
}

void Mail::base64Encode(char *attach, int len)
{
  unsigned char buffer[3];

  int idx=0;
  for (int i=0; i<(len/3); i++) {
    buffer[0]=attach[3*i];
    buffer[1]=attach[3*i+1];
    buffer[2]=attach[3*i+2];

    msg += (char) BASE64( buffer[0]>>2 );
    newLine(idx);
    msg += (char) BASE64(((buffer[0] & 0x03)<< 4) | (buffer[1] >> 4));
    newLine(idx);
    msg += (char) BASE64(((buffer[1] & 0x0F) << 2) | (buffer[2] >> 6));
    newLine(idx);
    msg += (char) BASE64(buffer[2] & 0x3F);
    newLine(idx);
  }
  buffer[0]=buffer[1]=buffer[2]=0;  
  if (len%3==1) {
    buffer[0] = attach[len-1];
    buffer[1] = 0;
    buffer[2] = 0;
    msg += (char) BASE64(buffer[0]>>2);
    newLine(idx);
    msg += (char) BASE64(((buffer[0] & 0x03)<< 4) | buffer[1] >> 4);
    newLine(idx);
    msg += "=";
    newLine(idx);
    msg += "=";
    newLine(idx);
  }
  else if (len%3==2) {
    buffer[0] = attach[len-2];
    buffer[1] = attach[len-1];
    buffer[2] = 0;
    msg += (char) BASE64(buffer[0]>>2);
    newLine(idx);
    msg += (char) BASE64(((buffer[0] & 0x03)<< 4) | (buffer[1] >> 4));
    newLine(idx);
    msg += (char) BASE64(((buffer[1] & 0x0F) << 2) | (buffer[2] >> 6));
    newLine(idx);
    msg += "=";
    newLine(idx);
  }  
  if (idx%64!=0)
    msg += "\r\n";
}

void Mail::newLine(int &idx)
{
  idx++;
  if (idx%64==0)
    msg += "\r\n";
}

void Mail::sendMail(QString &smtp, QString &port, bool useAuth, QString &login,
		    QString &password)
{
  Smtp *server = new Smtp(smtp,port,from,to,msg,useAuth,login,password);
  server->doNothing(); // To avoid a warning about unused variable.
}
