#include <qpushbutton.h>

#include "qnewgameimpl.h"

/* 
 *  Constructs a QNewGameImpl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
QNewGameImpl::QNewGameImpl( QWidget* parent, bool *h, gameType *gt,
			    int *cp)
  : newGameDialog( parent, "New Game dialog", true ), heuris(h),
    cheatProtection(cp),  type(gt)
{
  *heuris=true;
  *cheatProtection=1;
  buttonSolo->setEnabled(false);
}

/*  
 *  Destroys the object and frees any allocated resources
 */
QNewGameImpl::~QNewGameImpl()
{
  // no need to delete child widgets, Qt does it all for us
}

/*
 * public slot
 */
void QNewGameImpl::newSolo()
{
  *type = SOLO;
  done(0);
}

/*
 * public slot
 */
void QNewGameImpl::newHotseat()
{
  *type = HOTSEAT;
  done(0);
}

/*
 * public slot
 */
void QNewGameImpl::newPBEM()
{
  *type = PBEM;
  done(0);
}

/*
 * public slot
 */
void QNewGameImpl::newNetwork()
{
  *type = NETWORK;
  done(0);
}

void QNewGameImpl::toggleHeuristicTurn(bool ht)
{ *heuris = ht; }

void QNewGameImpl::toggleCheatEnable(bool click)
{ 
  if (click)
    *cheatProtection=1;
}

void QNewGameImpl::toggleCheatPartlyEnable(bool click)
{
  if (click)
    *cheatProtection=2;
}

void QNewGameImpl::toggleCheatDisable(bool click)
{
  if (click)
    *cheatProtection=3;
}
