#include <qstring.h>

#include "rand.h"

#include "gamemanager.h"

int Rand::roll(int n, bool store)
{
  man->disableUndo();
  if (man->isInReplayMode()) {
    QString val = man->getRecord();
    if (val.startsWith("diceroll")) {
      val.remove(0,9);
      int nb = val.toInt();
      return nb;
    }
    else
      cout << "Error : I should have received a diceroll command.\n";
  }
  seedvalue = rand();
  int nb = (int) ((float) seedvalue*n/(RAND_MAX+1.0)); 
  if (store)
    man->recordCommand(QString("diceroll ")+QString::number(nb)); 
  return nb;
}

int Rand::simpleroll(int n)
{
  return (int) ((float) rand()*n/(RAND_MAX+1.0)); 
}
