/***************************************************************************
                          guicreature.h  -  description
                             -------------------
    begin                : dim mar 24 15:54:00 CET 2002
    copyright            : (C) 2002 by Romain Vinot
    email                : vinot@aist.enst.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _GUICREATURE_H_
#define _GUICREATURE_H_

#include "creature.h"

class GUICreature {
public:
  GUICreature(void);
  virtual ~GUICreature(void);

  virtual void printInfo(BolterMarine *crea, bool isSelected, int loc=0)=0;
  virtual void printInfo(FlamerMarine *crea, bool isSelected, int loc=0)=0;
  virtual void printInfo(Sergeant *crea, bool isSelected, int loc=0)=0;
  virtual void printInfo(Genestealer *crea, bool isSelected, int loc=0)=0;
  virtual void printInfo(Blip *crea, bool isSelected, int loc=0)=0;
  virtual void printInfo(Door *door, bool isSelected, int loc=0)=0;
  virtual void printInfo(Bulkhead *bulkhead, bool isSelected, int loc=0)=0;
  virtual void printInfo(EntryZone *ez, bool isSelected, int loc=0)=0;
  virtual void printInfo(Flame *f, bool isSelected, int loc=0)=0;
  virtual void printInfo(ModuleCAT *mae, bool isSelected, int loc=0)=0;
  virtual void printInfo(Exit *exit, bool isSelected, int loc=0)=0;
  virtual void printInfo(ExtensibleObject *ext, bool isSelected, int loc=0)=0;

  virtual void printDetailZoneInfo(EntryZone *ez)=0;

  virtual void * getPixmap(BolterMarine *crea, bool b)=0;
  virtual void * getPixmap(Sergeant *crea, bool b)=0;
  virtual void * getPixmap(FlamerMarine *crea, bool b)=0;
  virtual void * getPixmap(Genestealer *crea, bool b)=0;
  virtual void * getPixmap(Blip *crea, bool b)=0;
  virtual void * getPixmap(Door *crea, bool b)=0;
  virtual void * getPixmap(Bulkhead *crea, bool b)=0;
  virtual void * getPixmap(Flame *crea, bool b)=0;
  virtual void * getPixmap(EntryZone *crea, bool b)=0;
  virtual void * getPixmap(ModuleCAT *mae, bool b)=0;
  virtual void * getPixmap(Exit *exit, bool b)=0;
  virtual void * getPixmap(ExtensibleObject *ext, bool b)=0;

  virtual void Message(QString msg)=0;
};

#endif
