/***************************************************************************
                          levelfct.cpp  -  description
                             -------------------
    begin                : sam avr 06 21:19:00 CET 2002
    copyright            : (C) 2002 by Romain Vinot
    email                : vinot@aist.enst.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "levelfct.h"
#include "levelobject.h"
#include "level.h"
#include "board.h"
#include "gamemanager.h"
#include "rand.h"
#include <map>
#include <iostream>

LvlFct* LvlFct::Build(QDomElement fct, Level *l)
{
  QString name = fct.tagName();
  if(name == "random")
    {
      return new LvlFctRandom(fct,l);
    }
  else if(name == "turn")
    {
      return new LvlFctTurn(fct,l);
    }
  else if(name == "blockedentry")
    {
      return new LvlFctBlockedEntry(fct,l);
    }
  else if(name == "leaved")
    {
      return new LvlFctLeaved(fct,l);
    }
  else if(name == "AP")
    {
      return new LvlFctAP(fct,l);
    }
  else if(name == "taken")
    {
      return new LvlFctTaken(fct,l);
    }
  else if(name == "size")
    {
      return new LvlFctSize(fct,l);
    }
  else if(name == "dead")
    {
      return new LvlFctDead(fct,l);
    }
  else if(name == "value")
    {
      return new LvlFctValue(fct,l);
    }
  else if(name == "sum")
    {
      return new LvlFctSum(fct,l);
    }
  else if(name == "product")
    {
      return new LvlFctProduct(fct,l);
    }
  else
    {
      cout << "Error , tag " << name << " does not exists" << endl;
      exit(10);
    }
}

LvlFct::LvlFct()
{
  level = NULL;
}

LvlFct::LvlFct(QDomElement fct, Level *l)
{
  node_fct = fct;
  level = l;
}

LvlFct::~LvlFct()
{
  level = NULL;
}

LvlFctRef::LvlFctRef(QDomElement fct, Level *l)
  : LvlFct(fct,l)
{
  name = node_fct.attribute("name");
}

int LvlFctRef::Eval()
{
  return level->getValue(name);
}

LvlFctRandom::LvlFctRandom(QDomElement fct, Level *l)
  : LvlFct(fct,l)
{
  QString str_min, str_max;
  str_min = node_fct.attribute("min","1");
  str_max = node_fct.attribute("max","6");
  min = str_min.toInt();
  if(str_max == "inf")
    {
      max = INT_MAX;
    }
  else
    {
      max = str_max.toInt();
    }
}

int LvlFctRandom::Eval()
{
  int value = Rand::roll(max);
  return value;
}

LvlFctTurn::LvlFctTurn(QDomElement fct, Level *l)
  : LvlFct(fct,l)
{
}

int LvlFctTurn::Eval()
{
  int nb = man->getTurnNumber();
  return nb;
}

LvlFctBlockedEntry::LvlFctBlockedEntry(QDomElement fct, Level *l)
  : LvlFct(fct,l)
{}

int LvlFctBlockedEntry::Eval()
{
  const set<int>* entries = board->getEntryZoneCases();
  int nb=0;
  for (set<int>::const_iterator it=entries->begin(); it!=entries->end(); it++){
    if (board->isEntryBlocked(*it))
      nb++;
  }
  return nb;
}

LvlFctLeaved::LvlFctLeaved(QDomElement fct, Level *l)
  : LvlFct(fct,l)
{
  QString str_type = node_fct.attribute("type");
  lvltype = LevelObject::Name2LvlType(str_type.latin1());
}

int LvlFctLeaved::Eval()
{
  int number=0;
  ObjectType type;
  for(int filter = 1 ; filter < (1 << NbLvlObjectType) ; filter <<= 1)
    {
      int cur = lvltype & filter;
      type = LevelObject::LvlType2Type((LvlObjectType)cur);
      if(type != NB_OBJECT_TYPE)
	{
	  const list<int>* lst = man->getExitedUnits(type);
	  if (lst != NULL)
	    number += lst->size();
	}
    }
  return number;
}

LvlFctAP::LvlFctAP(QDomElement fct, Level *l)
  : LvlFct(fct,l)
{
  QString str_op = node_fct.attribute("op","max");
  if(str_op == "min")
    {
      op = LvlFctAP::min;
    }
  else if(str_op == "mean")
    {
      op = LvlFctAP::mean;
    }
  else if(str_op = "sum")
    {
      op = LvlFctAP::sum;
    }
  else if(str_op = "prod")
    {
      op = LvlFctAP::max;
    }
  else
    {
      op = LvlFctAP::max;
    }
  ref_name = node_fct.attribute("ref");
}

int LvlFctAP::Eval()
{
  int AP;
  int result = 0, nb_AP = 0;
  LevelRef* ref = level->getRef(ref_name);
  LevelRef::iterator it;
  if(ref != NULL)
    {
      if(op == prod)
	{
	  result = 1;
	}
      else if(op == min)
	{
	  result = INT_MAX;
	}
      else if(op == max)
	{
	  result = 0;
	}
      cout << "\tref not NULL, size : " << ref->size() << endl;
      for(it = ref->begin() ; it != ref->end() ; it++)
	{
	  cout << "\ttesting object adress : " << *it << endl;
	  LvlUnit *unit = dynamic_cast<LvlUnit*>(*it);
	  if(unit != NULL)
	    {
	      AP = unit->getActPts();
	      cout << "\tFound unit with AP : " << AP << endl;
	      switch(op)
		{
		case max:
		  if(AP > result)
		    {
		      result = AP;
		    }
		  break;
		case min:
		  if(AP < result)
		    {
		      result = AP;
		    }
		  break;
		case sum:
		  result += AP;
		  break;
		case prod:
		  result *= AP;
		  break;
		case mean:
		  result += AP;
		  nb_AP ++;
		}
	    }
	}
    }
  if (op==mean)
    result/=nb_AP;
  cout << "\tresult = " << result << endl;
  return result;
}

LvlFctTaken::LvlFctTaken(QDomElement fct, Level *l)
  : LvlFct(fct,l)
{
  ref_name = node_fct.attribute("ref");
}

int LvlFctTaken::Eval()
{
  int nb_Taken = 0;
  LevelRef* ref = level->getRef(ref_name);
  LevelRef::iterator it;
  if(ref != NULL)
    {
      for(it = ref->begin() ; it != ref->end() ; it++)
	{
	  LvlUnit *unit = dynamic_cast<LvlUnit*>(*it);
	  if(unit != NULL && unit->hasAnObject())
	    {
	      nb_Taken++;
	    }
	}
    }
  return nb_Taken;
}

LvlFctSize::LvlFctSize(QDomElement fct, Level *l)
  : LvlFct(fct,l)
{
  ref_name = node_fct.attribute("ref");
}

int LvlFctSize::Eval()
{
  LevelRef* ref = level->getRef(ref_name);
  if(ref == NULL)
    {
      return 0;
    }
  return ref->size();
}

LvlFctDead::LvlFctDead(QDomElement fct, Level *l)
  : LvlFct(fct,l)
{
  QString str_type = node_fct.attribute("type");
  lvltype = LevelObject::Name2LvlType(str_type.latin1());
}

int LvlFctDead::Eval()
{
  int number = 0, filter, cur;
  ObjectType type;
  for(filter = 1 ; filter < (1 << NbLvlObjectType) ; filter <<= 1)
    {
      cur = lvltype & filter;
      type = LevelObject::LvlType2Type((LvlObjectType)cur);
      if(type != NB_OBJECT_TYPE)
	{
	  number += level->getNbKilled(type);
	}
    }
  return number;
}

LvlFctValue::LvlFctValue(QDomElement fct, Level *l)
  : LvlFct(fct,l)
{
  QString str_num = node_fct.attribute("number");
  if(str_num == "inf")
    {
      number = INT_MAX;
    }
  else
    {
      number = str_num.toInt();
    }
}

int LvlFctValue::Eval()
{
  return number;
}

LvlFctOps::LvlFctOps(QDomElement fct, Level *l)
  : LvlFct(fct,l)
{
  QString name;
  QDomElement child = node_fct.firstChild().toElement();
  while(!child.isNull())
    {
      args.push_back(LvlFct::Build(child,l));
      child = child.nextSibling().toElement();
    }
}

LvlFctOps::~LvlFctOps()
{
  while(!args.empty())
    {
      delete *args.begin();
      args.pop_front();
    }
}

LvlFctSum::LvlFctSum(QDomElement fct, Level *l)
  : LvlFctOps(fct,l)
{
}

int LvlFctSum::Eval()
{
  int value = 0;
  std::list<LvlFct*>::iterator it;
  for(it = args.begin() ; it != args.end() ; it++)
    {
      value += (*it)->Eval();
    }
  return value;
}

LvlFctProduct::LvlFctProduct(QDomElement fct, Level *l)
  : LvlFctOps(fct,l)
{
}

int LvlFctProduct::Eval()
{
  int value = 1;
  std::list<LvlFct*>::iterator it;
  for(it = args.begin() ; it != args.end() ; it++)
    {
      value *= (*it)->Eval();
    }
  return value;
}
